/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.mq.redis.config;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.system.SystemUtil;
import com.lenovo.cloud.framework.common.enums.DocumentEnum;
import com.lenovo.cloud.framework.mq.redis.core.RedisMQTemplate;
import com.lenovo.cloud.framework.mq.redis.core.job.RedisPendingMessageResendJob;
import com.lenovo.cloud.framework.mq.redis.core.pubsub.AbstractRedisChannelMessageListener;
import com.lenovo.cloud.framework.mq.redis.core.stream.AbstractRedisStreamMessageListener;
import com.lenovo.cloud.framework.redis.config.LenovoRedisAutoConfiguration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Bean;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.stream.Consumer;
import org.springframework.data.redis.connection.stream.ObjectRecord;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.listener.ChannelTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.stream.StreamListener;
import org.springframework.data.redis.stream.StreamMessageListenerContainer;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableScheduling
@AutoConfiguration(after={LenovoRedisAutoConfiguration.class})
public class LenovoRedisMQConsumerAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LenovoRedisMQConsumerAutoConfiguration.class);

    @Bean
    @ConditionalOnBean(value={AbstractRedisChannelMessageListener.class})
    public RedisMessageListenerContainer redisMessageListenerContainer(RedisMQTemplate redisMQTemplate, List<AbstractRedisChannelMessageListener<?>> list) {
        RedisMessageListenerContainer redisMessageListenerContainer = new RedisMessageListenerContainer();
        redisMessageListenerContainer.setConnectionFactory(redisMQTemplate.getRedisTemplate().getRequiredConnectionFactory());
        list.forEach(abstractRedisChannelMessageListener -> {
            abstractRedisChannelMessageListener.setRedisMQTemplate(redisMQTemplate);
            redisMessageListenerContainer.addMessageListener((MessageListener)abstractRedisChannelMessageListener, (Topic)new ChannelTopic(abstractRedisChannelMessageListener.getChannel()));
            log.info("[redisMessageListenerContainer][\u6ce8\u518c Channel({}) \u5bf9\u5e94\u7684\u76d1\u542c\u5668({})]", (Object)abstractRedisChannelMessageListener.getChannel(), (Object)abstractRedisChannelMessageListener.getClass().getName());
        });
        return redisMessageListenerContainer;
    }

    @Bean
    @ConditionalOnBean(value={AbstractRedisStreamMessageListener.class})
    public RedisPendingMessageResendJob redisPendingMessageResendJob(List<AbstractRedisStreamMessageListener<?>> list, RedisMQTemplate redisMQTemplate, @Value(value="${spring.application.name}") String string, RedissonClient redissonClient) {
        return new RedisPendingMessageResendJob(list, redisMQTemplate, string, redissonClient);
    }

    @Bean(initMethod="start", destroyMethod="stop")
    @ConditionalOnBean(value={AbstractRedisStreamMessageListener.class})
    public StreamMessageListenerContainer<String, ObjectRecord<String, String>> redisStreamMessageListenerContainer(RedisMQTemplate redisMQTemplate, List<AbstractRedisStreamMessageListener<?>> list) {
        RedisTemplate<String, ?> redisTemplate = redisMQTemplate.getRedisTemplate();
        LenovoRedisMQConsumerAutoConfiguration.checkRedisVersion(redisTemplate);
        StreamMessageListenerContainer.StreamMessageListenerContainerOptions streamMessageListenerContainerOptions = StreamMessageListenerContainer.StreamMessageListenerContainerOptions.builder().batchSize(10).targetType(String.class).build();
        StreamMessageListenerContainer streamMessageListenerContainer = StreamMessageListenerContainer.create((RedisConnectionFactory)redisMQTemplate.getRedisTemplate().getRequiredConnectionFactory(), (StreamMessageListenerContainer.StreamMessageListenerContainerOptions)streamMessageListenerContainerOptions);
        String string = LenovoRedisMQConsumerAutoConfiguration.buildConsumerName();
        list.parallelStream().forEach(abstractRedisStreamMessageListener -> {
            log.info("[redisStreamMessageListenerContainer][\u5f00\u59cb\u6ce8\u518c StreamKey({}) \u5bf9\u5e94\u7684\u76d1\u542c\u5668({})]", (Object)abstractRedisStreamMessageListener.getStreamKey(), (Object)abstractRedisStreamMessageListener.getClass().getName());
            try {
                redisTemplate.opsForStream().createGroup((Object)abstractRedisStreamMessageListener.getStreamKey(), abstractRedisStreamMessageListener.getGroup());
            }
            catch (Exception exception) {
                // empty catch block
            }
            abstractRedisStreamMessageListener.setRedisMQTemplate(redisMQTemplate);
            Consumer consumer = Consumer.from((String)abstractRedisStreamMessageListener.getGroup(), (String)string);
            StreamOffset streamOffset = StreamOffset.create((Object)abstractRedisStreamMessageListener.getStreamKey(), (ReadOffset)ReadOffset.lastConsumed());
            StreamMessageListenerContainer.ConsumerStreamReadRequestBuilder consumerStreamReadRequestBuilder = StreamMessageListenerContainer.StreamReadRequest.builder((StreamOffset)streamOffset).consumer(consumer).autoAcknowledge(false).cancelOnError(throwable -> false);
            streamMessageListenerContainer.register(consumerStreamReadRequestBuilder.build(), (StreamListener)abstractRedisStreamMessageListener);
            log.info("[redisStreamMessageListenerContainer][\u5b8c\u6210\u6ce8\u518c StreamKey({}) \u5bf9\u5e94\u7684\u76d1\u542c\u5668({})]", (Object)abstractRedisStreamMessageListener.getStreamKey(), (Object)abstractRedisStreamMessageListener.getClass().getName());
        });
        return streamMessageListenerContainer;
    }

    private static String buildConsumerName() {
        return String.format("%s@%d", SystemUtil.getHostInfo().getAddress(), SystemUtil.getCurrentPID());
    }

    private static void checkRedisVersion(RedisTemplate<String, ?> redisTemplate) {
        Properties properties = (Properties)redisTemplate.execute(RedisServerCommands::info);
        String string = MapUtil.getStr((Map)properties, (Object)"redis_version");
        int n = Integer.parseInt(StrUtil.subBefore((CharSequence)string, (char)'.', (boolean)false));
        if (n < 5) {
            throw new IllegalStateException(StrUtil.format((CharSequence)"\u60a8\u5f53\u524d\u7684 Redis \u7248\u672c\u4e3a {}\uff0c\u5c0f\u4e8e\u6700\u4f4e\u8981\u6c42\u7684 5.0.0 \u7248\u672c\uff01\u8bf7\u53c2\u8003 {} \u6587\u6863\u8fdb\u884c\u5b89\u88c5\u3002", (Object[])new Object[]{string, DocumentEnum.REDIS_INSTALL.getUrl()}));
        }
    }
}

