/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.mq.redis.core;

import com.lenovo.cloud.framework.common.util.json.JsonUtils;
import com.lenovo.cloud.framework.mq.redis.core.interceptor.RedisMessageInterceptor;
import com.lenovo.cloud.framework.mq.redis.core.message.AbstractRedisMessage;
import com.lenovo.cloud.framework.mq.redis.core.pubsub.AbstractRedisChannelMessage;
import com.lenovo.cloud.framework.mq.redis.core.stream.AbstractRedisStreamMessage;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.springframework.data.redis.connection.stream.Record;
import org.springframework.data.redis.connection.stream.RecordId;
import org.springframework.data.redis.connection.stream.StreamRecords;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisMQTemplate {
    private final RedisTemplate<String, ?> redisTemplate;
    private final List<RedisMessageInterceptor> interceptors = new ArrayList<RedisMessageInterceptor>();

    public <T extends AbstractRedisChannelMessage> void send(T t) {
        try {
            this.sendMessageBefore(t);
            this.redisTemplate.convertAndSend(t.getChannel(), (Object)JsonUtils.toJsonString(t));
        }
        finally {
            this.sendMessageAfter(t);
        }
    }

    public <T extends AbstractRedisStreamMessage> RecordId send(T t) {
        try {
            this.sendMessageBefore(t);
            RecordId recordId = this.redisTemplate.opsForStream().add((Record)StreamRecords.newRecord().ofObject((Object)JsonUtils.toJsonString(t)).withStreamKey((Object)t.getStreamKey()));
            return recordId;
        }
        finally {
            this.sendMessageAfter(t);
        }
    }

    public void addInterceptor(RedisMessageInterceptor redisMessageInterceptor) {
        this.interceptors.add(redisMessageInterceptor);
    }

    private void sendMessageBefore(AbstractRedisMessage abstractRedisMessage) {
        this.interceptors.forEach(redisMessageInterceptor -> redisMessageInterceptor.sendMessageBefore(abstractRedisMessage));
    }

    private void sendMessageAfter(AbstractRedisMessage abstractRedisMessage) {
        for (int i = this.interceptors.size() - 1; i >= 0; --i) {
            this.interceptors.get(i).sendMessageAfter(abstractRedisMessage);
        }
    }

    @Generated
    public RedisMQTemplate(RedisTemplate<String, ?> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    @Generated
    public RedisTemplate<String, ?> getRedisTemplate() {
        return this.redisTemplate;
    }

    @Generated
    public List<RedisMessageInterceptor> getInterceptors() {
        return this.interceptors;
    }
}

