/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.mq.redis.core.pubsub;

import cn.hutool.core.util.TypeUtil;
import com.lenovo.cloud.framework.common.util.json.JsonUtils;
import com.lenovo.cloud.framework.mq.redis.core.RedisMQTemplate;
import com.lenovo.cloud.framework.mq.redis.core.interceptor.RedisMessageInterceptor;
import com.lenovo.cloud.framework.mq.redis.core.message.AbstractRedisMessage;
import com.lenovo.cloud.framework.mq.redis.core.pubsub.AbstractRedisChannelMessage;
import java.lang.reflect.Type;
import java.util.List;
import lombok.Generated;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;

public abstract class AbstractRedisChannelMessageListener<T extends AbstractRedisChannelMessage>
implements MessageListener {
    private final Class<T> messageType = this.getMessageClass();
    private final String channel = ((AbstractRedisChannelMessage)this.messageType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getChannel();
    private RedisMQTemplate redisMQTemplate;

    protected AbstractRedisChannelMessageListener() {
    }

    public final String getChannel() {
        return this.channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onMessage(Message message, byte[] byArray) {
        AbstractRedisChannelMessage abstractRedisChannelMessage = (AbstractRedisChannelMessage)JsonUtils.parseObject((byte[])message.getBody(), this.messageType);
        try {
            this.consumeMessageBefore(abstractRedisChannelMessage);
            this.onMessage(abstractRedisChannelMessage);
        }
        finally {
            this.consumeMessageAfter(abstractRedisChannelMessage);
        }
    }

    public abstract void onMessage(T var1);

    private Class<T> getMessageClass() {
        Type type = TypeUtil.getTypeArgument(this.getClass(), (int)0);
        if (type == null) {
            throw new IllegalStateException(String.format("\u7c7b\u578b(%s) \u9700\u8981\u8bbe\u7f6e\u6d88\u606f\u7c7b\u578b", this.getClass().getName()));
        }
        return (Class)type;
    }

    private void consumeMessageBefore(AbstractRedisMessage abstractRedisMessage) {
        assert (this.redisMQTemplate != null);
        List<RedisMessageInterceptor> list = this.redisMQTemplate.getInterceptors();
        list.forEach(redisMessageInterceptor -> redisMessageInterceptor.consumeMessageBefore(abstractRedisMessage));
    }

    private void consumeMessageAfter(AbstractRedisMessage abstractRedisMessage) {
        assert (this.redisMQTemplate != null);
        List<RedisMessageInterceptor> list = this.redisMQTemplate.getInterceptors();
        for (int i = list.size() - 1; i >= 0; --i) {
            list.get(i).consumeMessageAfter(abstractRedisMessage);
        }
    }

    @Generated
    public AbstractRedisChannelMessageListener<T> setRedisMQTemplate(RedisMQTemplate redisMQTemplate) {
        this.redisMQTemplate = redisMQTemplate;
        return this;
    }
}

