/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.mq.redis.core.stream;

import cn.hutool.core.util.TypeUtil;
import com.lenovo.cloud.framework.common.util.json.JsonUtils;
import com.lenovo.cloud.framework.mq.redis.core.RedisMQTemplate;
import com.lenovo.cloud.framework.mq.redis.core.interceptor.RedisMessageInterceptor;
import com.lenovo.cloud.framework.mq.redis.core.message.AbstractRedisMessage;
import com.lenovo.cloud.framework.mq.redis.core.stream.AbstractRedisStreamMessage;
import java.lang.reflect.Type;
import java.util.List;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.connection.stream.ObjectRecord;
import org.springframework.data.redis.stream.StreamListener;

public abstract class AbstractRedisStreamMessageListener<T extends AbstractRedisStreamMessage>
implements StreamListener<String, ObjectRecord<String, String>> {
    private final Class<T> messageType = this.getMessageClass();
    private final String streamKey = ((AbstractRedisStreamMessage)this.messageType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).getStreamKey();
    @Value(value="${spring.application.name}")
    private String group;
    private RedisMQTemplate redisMQTemplate;

    protected AbstractRedisStreamMessageListener() {
    }

    public void onMessage(ObjectRecord<String, String> objectRecord) {
        AbstractRedisStreamMessage abstractRedisStreamMessage = (AbstractRedisStreamMessage)JsonUtils.parseObject((String)((String)objectRecord.getValue()), this.messageType);
        try {
            this.consumeMessageBefore(abstractRedisStreamMessage);
            this.onMessage(abstractRedisStreamMessage);
            this.redisMQTemplate.getRedisTemplate().opsForStream().acknowledge(this.group, objectRecord);
        }
        finally {
            this.consumeMessageAfter(abstractRedisStreamMessage);
        }
    }

    public abstract void onMessage(T var1);

    private Class<T> getMessageClass() {
        Type type = TypeUtil.getTypeArgument(this.getClass(), (int)0);
        if (type == null) {
            throw new IllegalStateException(String.format("\u7c7b\u578b(%s) \u9700\u8981\u8bbe\u7f6e\u6d88\u606f\u7c7b\u578b", this.getClass().getName()));
        }
        return (Class)type;
    }

    private void consumeMessageBefore(AbstractRedisMessage abstractRedisMessage) {
        assert (this.redisMQTemplate != null);
        List<RedisMessageInterceptor> list = this.redisMQTemplate.getInterceptors();
        list.forEach(redisMessageInterceptor -> redisMessageInterceptor.consumeMessageBefore(abstractRedisMessage));
    }

    private void consumeMessageAfter(AbstractRedisMessage abstractRedisMessage) {
        assert (this.redisMQTemplate != null);
        List<RedisMessageInterceptor> list = this.redisMQTemplate.getInterceptors();
        for (int i = list.size() - 1; i >= 0; --i) {
            list.get(i).consumeMessageAfter(abstractRedisMessage);
        }
    }

    @Generated
    public String getStreamKey() {
        return this.streamKey;
    }

    @Generated
    public String getGroup() {
        return this.group;
    }

    @Generated
    public AbstractRedisStreamMessageListener<T> setRedisMQTemplate(RedisMQTemplate redisMQTemplate) {
        this.redisMQTemplate = redisMQTemplate;
        return this;
    }
}

