/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.mq.rocketmq.utils;

import com.lenovo.cloud.framework.mq.rocketmq.constant.MessageDelayLevel;
import com.lenovo.cloud.framework.mq.rocketmq.properties.RocketEnhanceProperties;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.spring.core.RocketMQTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class RocketMqUtils {
    private static Logger log = LoggerFactory.getLogger(RocketMqUtils.class);
    private RocketMQTemplate rocketMQTemplate;
    private RocketEnhanceProperties rocketEnhanceProperties;

    public RocketMqUtils(RocketMQTemplate rocketMQTemplate, RocketEnhanceProperties rocketEnhanceProperties) {
        this.rocketMQTemplate = rocketMQTemplate;
        this.rocketEnhanceProperties = rocketEnhanceProperties;
    }

    public void sendTopic(String string, Object object) {
        string = this.reBuildDestination(string);
        Assert.notNull((Object)string, (String)"topicName is null ");
        Assert.notNull((Object)object, (String)"message is null ");
        log.debug("sendTopic topicName:{},message:{}", (Object)string, object);
        this.rocketMQTemplate.convertAndSend((Object)string, object);
    }

    public SendResult syncSendQueue(String string, Object object) {
        string = this.reBuildDestination(string);
        Assert.notNull((Object)string, (String)"queueName is null ");
        Assert.notNull((Object)object, (String)"message is null ");
        log.debug("syncSendQueue queueName:{},message:{}", (Object)string, object);
        SendResult sendResult = this.rocketMQTemplate.syncSend(string, object);
        log.debug("syncSendQueue result:{}", (Object)sendResult);
        return sendResult;
    }

    public void asyncSendQueue(String string, Object object) {
        string = this.reBuildDestination(string);
        Assert.notNull((Object)string, (String)"queueName is null ");
        Assert.notNull((Object)object, (String)"message is null ");
        log.debug("asyncSendQueue queueName:{},message:{}", (Object)string, object);
        this.rocketMQTemplate.asyncSend(string, object, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                log.debug("async onSuccess SendResult={}", (Object)sendResult);
            }

            public void onException(Throwable throwable) {
                log.debug("async onException Throwable={}", throwable);
            }
        });
    }

    public void asyncSendQueue(String string, Object object, SendCallback sendCallback) {
        string = this.reBuildDestination(string);
        Assert.notNull((Object)string, (String)"queueName is null ");
        Assert.notNull((Object)object, (String)"message is null ");
        log.debug("asyncSendQueue queueName:{},message:{},sendCallback:{}", new Object[]{string, object, sendCallback});
        this.rocketMQTemplate.asyncSend(string, object, sendCallback);
    }

    public void sendOneWay(String string, Object object) {
        string = this.reBuildDestination(string);
        Assert.notNull((Object)string, (String)"queueName is null ");
        Assert.notNull((Object)object, (String)"message is null ");
        log.debug("sendOneway queueName:{},message:{}", (Object)string, object);
        this.rocketMQTemplate.sendOneWay(string, object);
    }

    public void asyncDelayQueue(String string, Message<?> message, MessageDelayLevel messageDelayLevel) {
        string = this.reBuildDestination(string);
        Assert.notNull((Object)string, (String)"queueName is null ");
        Assert.notNull(message, (String)"message is null ");
        Assert.notNull((Object)((Object)messageDelayLevel), (String)"messageDelayLevel is null ");
        log.debug("asyncDelayQueue queueName:{},message:{},delayLevel:{}", new Object[]{string, message, messageDelayLevel});
        this.rocketMQTemplate.asyncSend(string, message, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                log.debug("asyncDelayQueue onSuccess SendResult={}", (Object)sendResult);
            }

            public void onException(Throwable throwable) {
                log.debug("asyncDelayQueue onException Throwable={}", throwable);
            }
        }, (long)this.rocketMQTemplate.getProducer().getSendMsgTimeout(), messageDelayLevel.getValue());
    }

    public void asyncDelayQueue(String string, Message<?> message, MessageDelayLevel messageDelayLevel, SendCallback sendCallback) {
        string = this.reBuildDestination(string);
        Assert.notNull((Object)string, (String)"queueName is null ");
        Assert.notNull(message, (String)"message is null ");
        Assert.notNull((Object)((Object)messageDelayLevel), (String)"messageDelayLevel is null ");
        log.debug("asyncDelayQueue queueName:{},message:{},delayLevel:{},sendCallback:{}", new Object[]{string, message, messageDelayLevel, sendCallback});
        this.rocketMQTemplate.asyncSend(string, message, sendCallback, (long)this.rocketMQTemplate.getProducer().getSendMsgTimeout(), messageDelayLevel.getValue());
    }

    public SendResult syncDelayQueue(String string, Message<?> message, MessageDelayLevel messageDelayLevel) {
        string = this.reBuildDestination(string);
        Assert.notNull((Object)string, (String)"queueName is null ");
        Assert.notNull(message, (String)"message is null ");
        Assert.notNull((Object)((Object)messageDelayLevel), (String)"messageDelayLevel is null ");
        log.debug("syncDelayQueue queueName:{},message:{},delayLevel:{}", new Object[]{string, message, messageDelayLevel});
        SendResult sendResult = this.rocketMQTemplate.syncSend(string, message, (long)this.rocketMQTemplate.getProducer().getSendMsgTimeout(), messageDelayLevel.getValue());
        log.debug("syncDelayQueue result:{}", (Object)sendResult);
        return sendResult;
    }

    private String reBuildDestination(String string) {
        if (this.rocketEnhanceProperties.isEnabledIsolation() && StringUtils.hasText((String)this.rocketEnhanceProperties.getEnvironment())) {
            return string + "_" + this.rocketEnhanceProperties.getEnvironment();
        }
        return string;
    }
}

