/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.datasource.config;

import com.alibaba.druid.spring.boot3.autoconfigure.properties.DruidStatProperties;
import com.lenovo.cloud.framework.datasource.core.filter.DruidAdRemoveFilter;
import jakarta.servlet.Filter;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@AutoConfiguration
@EnableTransactionManagement(proxyTargetClass=true)
@EnableConfigurationProperties(value={DruidStatProperties.class})
public class LenovoDataSourceAutoConfiguration {
    @Bean
    @ConditionalOnProperty(name={"spring.datasource.druid.stat-view-servlet.enabled"}, havingValue="true")
    public FilterRegistrationBean<DruidAdRemoveFilter> druidAdRemoveFilterFilter(DruidStatProperties druidStatProperties) {
        DruidStatProperties.StatViewServlet statViewServlet = druidStatProperties.getStatViewServlet();
        String string = statViewServlet.getUrlPattern() != null ? statViewServlet.getUrlPattern() : "/druid/*";
        String string2 = string.replaceAll("\\*", "js/common.js");
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new DruidAdRemoveFilter());
        filterRegistrationBean.addUrlPatterns(new String[]{string2});
        return filterRegistrationBean;
    }
}

