/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.mybatis.config;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.annotation.IdType;
import com.lenovo.cloud.framework.common.util.collection.SetUtils;
import com.lenovo.cloud.framework.mybatis.core.util.JdbcUtils;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;

public class IdTypeEnvironmentPostProcessor
implements EnvironmentPostProcessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdTypeEnvironmentPostProcessor.class);
    private static final String ID_TYPE_KEY = "mybatis-plus.global-config.db-config.id-type";
    private static final String DATASOURCE_DYNAMIC_KEY = "spring.datasource.dynamic";
    private static final String QUARTZ_JOB_STORE_DRIVER_KEY = "spring.quartz.properties.org.quartz.jobStore.driverDelegateClass";
    private static final Set<DbType> INPUT_ID_TYPES = SetUtils.asSet((Object[])new DbType[]{DbType.ORACLE, DbType.ORACLE_12C, DbType.POSTGRE_SQL, DbType.KINGBASE_ES, DbType.DB2, DbType.H2});

    public void postProcessEnvironment(ConfigurableEnvironment configurableEnvironment, SpringApplication springApplication) {
        DbType dbType = IdTypeEnvironmentPostProcessor.getDbType(configurableEnvironment);
        if (dbType == null) {
            return;
        }
        this.setJobStoreDriverIfPresent(configurableEnvironment, dbType);
        IdType idType = this.getIdType(configurableEnvironment);
        if (idType != IdType.NONE) {
            return;
        }
        if (INPUT_ID_TYPES.contains(dbType)) {
            this.setIdType(configurableEnvironment, IdType.INPUT);
            return;
        }
        this.setIdType(configurableEnvironment, IdType.AUTO);
    }

    public IdType getIdType(ConfigurableEnvironment configurableEnvironment) {
        return (IdType)configurableEnvironment.getProperty(ID_TYPE_KEY, IdType.class);
    }

    public void setIdType(ConfigurableEnvironment configurableEnvironment, IdType idType) {
        configurableEnvironment.getSystemProperties().put(ID_TYPE_KEY, idType);
        log.info("[setIdType][\u4fee\u6539 MyBatis Plus \u7684 idType \u4e3a({})]", (Object)idType);
    }

    public void setJobStoreDriverIfPresent(ConfigurableEnvironment configurableEnvironment, DbType dbType) {
        String string = configurableEnvironment.getProperty(QUARTZ_JOB_STORE_DRIVER_KEY);
        if (StrUtil.isNotEmpty((CharSequence)string)) {
            return;
        }
        switch (dbType) {
            case POSTGRE_SQL: {
                string = "org.quartz.impl.jdbcjobstore.PostgreSQLDelegate";
                break;
            }
            case ORACLE: 
            case ORACLE_12C: {
                string = "org.quartz.impl.jdbcjobstore.oracle.OracleDelegate";
                break;
            }
            case SQL_SERVER: 
            case SQL_SERVER2005: {
                string = "org.quartz.impl.jdbcjobstore.MSSQLDelegate";
                break;
            }
            case DM: 
            case KINGBASE_ES: {
                string = "org.quartz.impl.jdbcjobstore.StdJDBCDelegate";
            }
        }
        if (StrUtil.isNotEmpty((CharSequence)string)) {
            configurableEnvironment.getSystemProperties().put(QUARTZ_JOB_STORE_DRIVER_KEY, string);
        }
    }

    public static DbType getDbType(ConfigurableEnvironment configurableEnvironment) {
        String string = configurableEnvironment.getProperty("spring.datasource.dynamic.primary");
        if (StrUtil.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = configurableEnvironment.getProperty("spring.datasource.dynamic.datasource." + string + ".url");
        if (StrUtil.isEmpty((CharSequence)string2)) {
            return null;
        }
        return JdbcUtils.getDbType(string2);
    }
}

