/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.mybatis.config;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusAutoConfiguration;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.baomidou.mybatisplus.core.incrementer.IKeyGenerator;
import com.baomidou.mybatisplus.extension.incrementer.DmKeyGenerator;
import com.baomidou.mybatisplus.extension.incrementer.H2KeyGenerator;
import com.baomidou.mybatisplus.extension.incrementer.KingbaseKeyGenerator;
import com.baomidou.mybatisplus.extension.incrementer.OracleKeyGenerator;
import com.baomidou.mybatisplus.extension.incrementer.PostgreKeyGenerator;
import com.baomidou.mybatisplus.extension.parser.JsqlParserGlobal;
import com.baomidou.mybatisplus.extension.parser.cache.JdkSerialCaffeineJsqlParseCache;
import com.baomidou.mybatisplus.extension.parser.cache.JsqlParseCache;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.lenovo.cloud.framework.mybatis.config.IdTypeEnvironmentPostProcessor;
import com.lenovo.cloud.framework.mybatis.core.handler.DefaultDBFieldHandler;
import java.util.concurrent.TimeUnit;
import org.apache.ibatis.annotations.Mapper;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.ConfigurableEnvironment;

@AutoConfiguration(before={MybatisPlusAutoConfiguration.class})
@MapperScan(value={"${lenovo.info.base-package}"}, annotationClass=Mapper.class, lazyInitialization="${mybatis.lazy-initialization:false}")
public class LenovoMybatisAutoConfiguration {
    @Bean
    public MybatisPlusInterceptor mybatisPlusInterceptor() {
        MybatisPlusInterceptor mybatisPlusInterceptor = new MybatisPlusInterceptor();
        mybatisPlusInterceptor.addInnerInterceptor((InnerInterceptor)new PaginationInnerInterceptor());
        return mybatisPlusInterceptor;
    }

    @Bean
    public MetaObjectHandler defaultMetaObjectHandler() {
        return new DefaultDBFieldHandler();
    }

    @Bean
    @ConditionalOnProperty(prefix="mybatis-plus.global-config.db-config", name={"id-type"}, havingValue="INPUT")
    public IKeyGenerator keyGenerator(ConfigurableEnvironment configurableEnvironment) {
        DbType dbType = IdTypeEnvironmentPostProcessor.getDbType(configurableEnvironment);
        if (dbType != null) {
            switch (dbType) {
                case POSTGRE_SQL: {
                    return new PostgreKeyGenerator();
                }
                case ORACLE: 
                case ORACLE_12C: {
                    return new OracleKeyGenerator();
                }
                case H2: {
                    return new H2KeyGenerator();
                }
                case KINGBASE_ES: {
                    return new KingbaseKeyGenerator();
                }
                case DM: {
                    return new DmKeyGenerator();
                }
            }
        }
        throw new IllegalArgumentException(StrUtil.format((CharSequence)"DbType{} \u627e\u4e0d\u5230\u5408\u9002\u7684 IKeyGenerator \u5b9e\u73b0\u7c7b", (Object[])new Object[]{dbType}));
    }

    static {
        JsqlParserGlobal.setJsqlParseCache((JsqlParseCache)new JdkSerialCaffeineJsqlParseCache(caffeine -> caffeine.maximumSize(1024L).expireAfterWrite(5L, TimeUnit.SECONDS)));
    }
}

