/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.mybatis.core.enums;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.DbType;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;

public enum DbTypeEnum {
    H2(DbType.H2, "H2", ""),
    MY_SQL(DbType.MYSQL, "MySQL", "FIND_IN_SET('#{value}', #{column}) <> 0"),
    ORACLE(DbType.ORACLE, "Oracle", "FIND_IN_SET('#{value}', #{column}) <> 0"),
    POSTGRE_SQL(DbType.POSTGRE_SQL, "PostgreSQL", "POSITION('#{value}' IN #{column}) <> 0"),
    SQL_SERVER(DbType.SQL_SERVER, "Microsoft SQL Server", "CHARINDEX(',' + #{value} + ',', ',' + #{column} + ',') <> 0"),
    SQL_SERVER2005(DbType.SQL_SERVER2005, "Microsoft SQL Server 2005", "CHARINDEX(',' + #{value} + ',', ',' + #{column} + ',') <> 0"),
    DM(DbType.DM, "DM DBMS", "FIND_IN_SET('#{value}', #{column}) <> 0"),
    KINGBASE_ES(DbType.KINGBASE_ES, "KingbaseES", "POSITION('#{value}' IN #{column}) <> 0");

    public static final Map<String, DbTypeEnum> MAP_BY_NAME;
    public static final Map<DbType, DbTypeEnum> MAP_BY_MP;
    private final DbType mpDbType;
    private final String productName;
    private final String findInSetTemplate;

    public static DbType find(String string) {
        if (StrUtil.isBlank((CharSequence)string)) {
            return null;
        }
        return MAP_BY_NAME.get(string).getMpDbType();
    }

    public static String getFindInSetTemplate(DbType dbType) {
        return Optional.of(MAP_BY_MP.get(dbType).getFindInSetTemplate()).orElseThrow(() -> new IllegalArgumentException("FIND_IN_SET not supported"));
    }

    @Generated
    public DbType getMpDbType() {
        return this.mpDbType;
    }

    @Generated
    public String getProductName() {
        return this.productName;
    }

    @Generated
    public String getFindInSetTemplate() {
        return this.findInSetTemplate;
    }

    @Generated
    private DbTypeEnum(DbType dbType, String string2, String string3) {
        this.mpDbType = dbType;
        this.productName = string2;
        this.findInSetTemplate = string3;
    }

    static {
        MAP_BY_NAME = Arrays.stream(DbTypeEnum.values()).collect(Collectors.toMap(DbTypeEnum::getProductName, Function.identity()));
        MAP_BY_MP = Arrays.stream(DbTypeEnum.values()).collect(Collectors.toMap(DbTypeEnum::getMpDbType, Function.identity()));
    }
}

