/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.mybatis.core.mapper;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.toolkit.Db;
import com.github.yulichang.base.MPJBaseMapper;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import com.lenovo.cloud.framework.common.pojo.PageParam;
import com.lenovo.cloud.framework.common.pojo.PageResult;
import com.lenovo.cloud.framework.common.pojo.SortablePageParam;
import com.lenovo.cloud.framework.common.pojo.SortingField;
import com.lenovo.cloud.framework.mybatis.core.util.JdbcUtils;
import com.lenovo.cloud.framework.mybatis.core.util.MyBatisUtils;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.annotations.Param;

public interface BaseMapperX<T>
extends MPJBaseMapper<T> {
    default public PageResult<T> selectPage(SortablePageParam sortablePageParam, @Param(value="ew") Wrapper<T> wrapper) {
        return this.selectPage((PageParam)sortablePageParam, sortablePageParam.getSortingFields(), wrapper);
    }

    default public PageResult<T> selectPage(PageParam pageParam, @Param(value="ew") Wrapper<T> wrapper) {
        return this.selectPage(pageParam, null, wrapper);
    }

    default public PageResult<T> selectPage(PageParam pageParam, Collection<SortingField> collection, @Param(value="ew") Wrapper<T> wrapper) {
        if (PageParam.PAGE_SIZE_NONE.equals(pageParam.getPageSize())) {
            List list = this.selectList(wrapper);
            return new PageResult(list, Long.valueOf(list.size()));
        }
        Page page = MyBatisUtils.buildPage(pageParam, collection);
        this.selectPage((IPage)page, (Wrapper)wrapper);
        return new PageResult(page.getRecords(), Long.valueOf(page.getTotal()));
    }

    default public <D> PageResult<D> selectJoinPage(PageParam pageParam, Class<D> clazz, MPJLambdaWrapper<T> mPJLambdaWrapper) {
        if (PageParam.PAGE_SIZE_NONE.equals(pageParam.getPageSize())) {
            List list = this.selectJoinList(clazz, (MPJBaseJoin)mPJLambdaWrapper);
            return new PageResult(list, Long.valueOf(list.size()));
        }
        IPage iPage = MyBatisUtils.buildPage(pageParam);
        iPage = this.selectJoinPage(iPage, clazz, (MPJBaseJoin)mPJLambdaWrapper);
        return new PageResult(iPage.getRecords(), Long.valueOf(iPage.getTotal()));
    }

    default public <DTO> PageResult<DTO> selectJoinPage(PageParam pageParam, Class<DTO> clazz, MPJBaseJoin<T> mPJBaseJoin) {
        Page page = MyBatisUtils.buildPage(pageParam);
        this.selectJoinPage((IPage)page, clazz, (MPJBaseJoin)mPJBaseJoin);
        return new PageResult(page.getRecords(), Long.valueOf(page.getTotal()));
    }

    default public T selectOne(String string, Object object) {
        return (T)this.selectOne((Wrapper)new QueryWrapper().eq((Object)string, object));
    }

    default public T selectOne(SFunction<T, ?> sFunction, Object object) {
        return (T)this.selectOne((Wrapper)new LambdaQueryWrapper().eq(sFunction, object));
    }

    default public T selectOne(String string, Object object, String string2, Object object2) {
        return (T)this.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)string, object)).eq((Object)string2, object2));
    }

    default public T selectOne(SFunction<T, ?> sFunction, Object object, SFunction<T, ?> sFunction2, Object object2) {
        return (T)this.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(sFunction, object)).eq(sFunction2, object2));
    }

    default public T selectOne(SFunction<T, ?> sFunction, Object object, SFunction<T, ?> sFunction2, Object object2, SFunction<T, ?> sFunction3, Object object3) {
        return (T)this.selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(sFunction, object)).eq(sFunction2, object2)).eq(sFunction3, object3));
    }

    default public T selectFirstOne(SFunction<T, ?> sFunction, Object object) {
        List list = this.selectList((Wrapper)new LambdaQueryWrapper().eq(sFunction, object));
        return (T)CollUtil.getFirst((Iterable)list);
    }

    default public T selectFirstOne(SFunction<T, ?> sFunction, Object object, SFunction<T, ?> sFunction2, Object object2) {
        List list = this.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(sFunction, object)).eq(sFunction2, object2));
        return (T)CollUtil.getFirst((Iterable)list);
    }

    default public T selectFirstOne(SFunction<T, ?> sFunction, Object object, SFunction<T, ?> sFunction2, Object object2, SFunction<T, ?> sFunction3, Object object3) {
        List list = this.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(sFunction, object)).eq(sFunction2, object2)).eq(sFunction3, object3));
        return (T)CollUtil.getFirst((Iterable)list);
    }

    default public Long selectCount() {
        return this.selectCount((Wrapper)new QueryWrapper());
    }

    default public Long selectCount(String string, Object object) {
        return this.selectCount((Wrapper)new QueryWrapper().eq((Object)string, object));
    }

    default public Long selectCount(SFunction<T, ?> sFunction, Object object) {
        return this.selectCount((Wrapper)new LambdaQueryWrapper().eq(sFunction, object));
    }

    default public List<T> selectList() {
        return this.selectList((Wrapper)new QueryWrapper());
    }

    default public List<T> selectList(String string, Object object) {
        return this.selectList((Wrapper)new QueryWrapper().eq((Object)string, object));
    }

    default public List<T> selectList(SFunction<T, ?> sFunction, Object object) {
        return this.selectList((Wrapper)new LambdaQueryWrapper().eq(sFunction, object));
    }

    default public List<T> selectList(String string, Collection<?> collection) {
        if (CollUtil.isEmpty(collection)) {
            return CollUtil.newArrayList((Object[])new Object[0]);
        }
        return this.selectList((Wrapper)new QueryWrapper().in((Object)string, collection));
    }

    default public List<T> selectList(SFunction<T, ?> sFunction, Collection<?> collection) {
        if (CollUtil.isEmpty(collection)) {
            return CollUtil.newArrayList((Object[])new Object[0]);
        }
        return this.selectList((Wrapper)new LambdaQueryWrapper().in(sFunction, collection));
    }

    default public List<T> selectList(SFunction<T, ?> sFunction, Object object, SFunction<T, ?> sFunction2, Object object2) {
        return this.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(sFunction, object)).eq(sFunction2, object2));
    }

    default public Boolean insertBatch(Collection<T> collection) {
        DbType dbType = JdbcUtils.getDbType();
        if (JdbcUtils.isSQLServer(dbType)) {
            collection.forEach(arg_0 -> ((BaseMapperX)this).insert(arg_0));
            return CollUtil.isNotEmpty(collection);
        }
        return Db.saveBatch(collection);
    }

    default public Boolean insertBatch(Collection<T> collection, int n) {
        DbType dbType = JdbcUtils.getDbType();
        if (JdbcUtils.isSQLServer(dbType)) {
            collection.forEach(arg_0 -> ((BaseMapperX)this).insert(arg_0));
            return CollUtil.isNotEmpty(collection);
        }
        return Db.saveBatch(collection, (int)n);
    }

    default public int updateBatch(T t) {
        return this.update(t, (Wrapper)new QueryWrapper());
    }

    default public Boolean updateBatch(Collection<T> collection) {
        return Db.updateBatchById(collection);
    }

    default public Boolean updateBatch(Collection<T> collection, int n) {
        return Db.updateBatchById(collection, (int)n);
    }

    default public int delete(String string, String string2) {
        return this.delete((Wrapper)new QueryWrapper().eq((Object)string, (Object)string2));
    }

    default public int delete(SFunction<T, ?> sFunction, Object object) {
        return this.delete((Wrapper)new LambdaQueryWrapper().eq(sFunction, object));
    }
}

