/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.mybatis.core.type;

import cn.hutool.core.lang.Assert;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.AES;
import cn.hutool.extra.spring.SpringUtil;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class EncryptTypeHandler
extends BaseTypeHandler<String> {
    private static final String ENCRYPTOR_PROPERTY_NAME = "mybatis-plus.encryptor.password";
    private static AES aes;

    public void setNonNullParameter(PreparedStatement preparedStatement, int n, String string, JdbcType jdbcType) throws SQLException {
        preparedStatement.setString(n, EncryptTypeHandler.encrypt(string));
    }

    public String getNullableResult(ResultSet resultSet, String string) throws SQLException {
        String string2 = resultSet.getString(string);
        return EncryptTypeHandler.decrypt(string2);
    }

    public String getNullableResult(ResultSet resultSet, int n) throws SQLException {
        String string = resultSet.getString(n);
        return EncryptTypeHandler.decrypt(string);
    }

    public String getNullableResult(CallableStatement callableStatement, int n) throws SQLException {
        String string = callableStatement.getString(n);
        return EncryptTypeHandler.decrypt(string);
    }

    private static String decrypt(String string) {
        if (string == null) {
            return null;
        }
        return EncryptTypeHandler.getEncryptor().decryptStr(string);
    }

    public static String encrypt(String string) {
        if (string == null) {
            return null;
        }
        return EncryptTypeHandler.getEncryptor().encryptBase64(string);
    }

    private static AES getEncryptor() {
        if (aes != null) {
            return aes;
        }
        String string = SpringUtil.getProperty((String)ENCRYPTOR_PROPERTY_NAME);
        Assert.notEmpty((CharSequence)string, (String)"\u914d\u7f6e\u9879({}) \u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[]{ENCRYPTOR_PROPERTY_NAME});
        aes = SecureUtil.aes((byte[])string.getBytes());
        return aes;
    }
}

