/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.mybatis.core.type;

import cn.hutool.core.collection.CollUtil;
import com.lenovo.cloud.framework.common.util.string.StrUtils;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.apache.ibatis.type.TypeHandler;

@MappedJdbcTypes(value={JdbcType.VARCHAR})
@MappedTypes(value={List.class})
public class LongListTypeHandler
implements TypeHandler<List<Long>> {
    private static final String COMMA = ",";

    public void setParameter(PreparedStatement preparedStatement, int n, List<Long> list, JdbcType jdbcType) throws SQLException {
        preparedStatement.setString(n, CollUtil.join(list, (CharSequence)COMMA));
    }

    public List<Long> getResult(ResultSet resultSet, String string) throws SQLException {
        String string2 = resultSet.getString(string);
        return this.getResult(string2);
    }

    public List<Long> getResult(ResultSet resultSet, int n) throws SQLException {
        String string = resultSet.getString(n);
        return this.getResult(string);
    }

    public List<Long> getResult(CallableStatement callableStatement, int n) throws SQLException {
        String string = callableStatement.getString(n);
        return this.getResult(string);
    }

    private List<Long> getResult(String string) {
        if (string == null) {
            return null;
        }
        return StrUtils.splitToLong((String)string, (CharSequence)COMMA);
    }
}

