/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.mybatis.core.type;

import cn.hutool.core.collection.CollUtil;
import com.lenovo.cloud.framework.common.util.string.StrUtils;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.apache.ibatis.type.TypeHandler;

@MappedJdbcTypes(value={JdbcType.VARCHAR})
@MappedTypes(value={List.class})
public class LongSetTypeHandler
implements TypeHandler<Set<Long>> {
    private static final String COMMA = ",";

    public void setParameter(PreparedStatement preparedStatement, int n, Set<Long> set, JdbcType jdbcType) throws SQLException {
        preparedStatement.setString(n, CollUtil.join(set, (CharSequence)COMMA));
    }

    public Set<Long> getResult(ResultSet resultSet, String string) throws SQLException {
        String string2 = resultSet.getString(string);
        return this.getResult(string2);
    }

    public Set<Long> getResult(ResultSet resultSet, int n) throws SQLException {
        String string = resultSet.getString(n);
        return this.getResult(string);
    }

    public Set<Long> getResult(CallableStatement callableStatement, int n) throws SQLException {
        String string = callableStatement.getString(n);
        return this.getResult(string);
    }

    private Set<Long> getResult(String string) {
        if (string == null) {
            return null;
        }
        return StrUtils.splitToLongSet((String)string, (CharSequence)COMMA);
    }
}

