/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.mybatis.core.util;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.lenovo.cloud.framework.common.pojo.PageParam;
import com.lenovo.cloud.framework.common.pojo.SortingField;
import com.lenovo.cloud.framework.mybatis.core.enums.DbTypeEnum;
import com.lenovo.cloud.framework.mybatis.core.util.JdbcUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;

public class MyBatisUtils {
    private static final String MYSQL_ESCAPE_CHARACTER = "`";

    public static <T> Page<T> buildPage(PageParam pageParam) {
        return MyBatisUtils.buildPage(pageParam, null);
    }

    public static <T> Page<T> buildPage(PageParam pageParam, Collection<SortingField> collection) {
        Page page = new Page((long)pageParam.getPageNo().intValue(), (long)pageParam.getPageSize().intValue());
        if (!CollectionUtil.isEmpty(collection)) {
            page.addOrder(collection.stream().map(sortingField -> "asc".equals(sortingField.getOrder()) ? OrderItem.asc((String)StrUtil.toUnderlineCase((CharSequence)sortingField.getField())) : OrderItem.desc((String)StrUtil.toUnderlineCase((CharSequence)sortingField.getField()))).collect(Collectors.toList()));
        }
        return page;
    }

    public static void addInterceptor(MybatisPlusInterceptor mybatisPlusInterceptor, InnerInterceptor innerInterceptor, int n) {
        ArrayList<InnerInterceptor> arrayList = new ArrayList<InnerInterceptor>(mybatisPlusInterceptor.getInterceptors());
        arrayList.add(n, innerInterceptor);
        mybatisPlusInterceptor.setInterceptors(arrayList);
    }

    public static String getTableName(Table table) {
        String string = table.getName();
        if (string.startsWith(MYSQL_ESCAPE_CHARACTER) && string.endsWith(MYSQL_ESCAPE_CHARACTER)) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static Column buildColumn(String string, Alias alias, String string2) {
        if (alias != null) {
            string = alias.getName();
        }
        return new Column(string + "." + string2);
    }

    public static String findInSet(String string, Object object) {
        DbType dbType = JdbcUtils.getDbType();
        return DbTypeEnum.getFindInSetTemplate(dbType).replace("#{column}", string).replace("#{value}", StrUtil.toString((Object)object));
    }
}

