/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.idempotent.core.aop;

import com.lenovo.cloud.framework.common.exception.ServiceException;
import com.lenovo.cloud.framework.common.exception.enums.GlobalErrorCodeConstants;
import com.lenovo.cloud.framework.common.util.collection.CollectionUtils;
import com.lenovo.cloud.framework.idempotent.core.annotation.Idempotent;
import com.lenovo.cloud.framework.idempotent.core.keyresolver.IdempotentKeyResolver;
import com.lenovo.cloud.framework.idempotent.core.redis.IdempotentRedisDAO;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@Aspect
public class IdempotentAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IdempotentAspect.class);
    private final Map<Class<? extends IdempotentKeyResolver>, IdempotentKeyResolver> keyResolvers;
    private final IdempotentRedisDAO idempotentRedisDAO;

    public IdempotentAspect(List<IdempotentKeyResolver> list, IdempotentRedisDAO idempotentRedisDAO) {
        this.keyResolvers = CollectionUtils.convertMap(list, Object::getClass);
        this.idempotentRedisDAO = idempotentRedisDAO;
    }

    @Around(value="@annotation(idempotent)")
    public Object aroundPointCut(ProceedingJoinPoint proceedingJoinPoint, Idempotent idempotent) throws Throwable {
        IdempotentKeyResolver idempotentKeyResolver = this.keyResolvers.get(idempotent.keyResolver());
        Assert.notNull((Object)idempotentKeyResolver, (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684 IdempotentKeyResolver");
        String string = idempotentKeyResolver.resolver((JoinPoint)proceedingJoinPoint, idempotent);
        boolean bl = this.idempotentRedisDAO.setIfAbsent(string, idempotent.timeout(), idempotent.timeUnit());
        if (!bl) {
            log.info("[aroundPointCut][\u65b9\u6cd5({}) \u53c2\u6570({}) \u5b58\u5728\u91cd\u590d\u8bf7\u6c42]", (Object)proceedingJoinPoint.getSignature().toString(), (Object)proceedingJoinPoint.getArgs());
            throw new ServiceException(GlobalErrorCodeConstants.REPEATED_REQUESTS.getCode(), idempotent.message());
        }
        try {
            return proceedingJoinPoint.proceed();
        }
        catch (Throwable throwable) {
            if (idempotent.deleteKeyWhenException()) {
                this.idempotentRedisDAO.delete(string);
            }
            throw throwable;
        }
    }
}

