/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.idempotent.core.keyresolver.impl;

import cn.hutool.core.util.ArrayUtil;
import com.lenovo.cloud.framework.idempotent.core.annotation.Idempotent;
import com.lenovo.cloud.framework.idempotent.core.keyresolver.IdempotentKeyResolver;
import java.lang.reflect.Method;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class ExpressionIdempotentKeyResolver
implements IdempotentKeyResolver {
    private final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private final ExpressionParser expressionParser = new SpelExpressionParser();

    @Override
    public String resolver(JoinPoint joinPoint, Idempotent idempotent) {
        Method method = ExpressionIdempotentKeyResolver.getMethod(joinPoint);
        Object[] objectArray = joinPoint.getArgs();
        Object[] objectArray2 = this.parameterNameDiscoverer.getParameterNames(method);
        StandardEvaluationContext standardEvaluationContext = new StandardEvaluationContext();
        if (ArrayUtil.isNotEmpty((Object[])objectArray2)) {
            for (int i = 0; i < objectArray2.length; ++i) {
                standardEvaluationContext.setVariable((String)objectArray2[i], objectArray[i]);
            }
        }
        Expression expression = this.expressionParser.parseExpression(idempotent.keyArg());
        return (String)expression.getValue((EvaluationContext)standardEvaluationContext, String.class);
    }

    private static Method getMethod(JoinPoint joinPoint) {
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        if (!method.getDeclaringClass().isInterface()) {
            return method;
        }
        try {
            return joinPoint.getTarget().getClass().getDeclaredMethod(joinPoint.getSignature().getName(), method.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }
}

