/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.ratelimiter.core.aop;

import cn.hutool.core.util.StrUtil;
import com.lenovo.cloud.framework.common.exception.ServiceException;
import com.lenovo.cloud.framework.common.exception.enums.GlobalErrorCodeConstants;
import com.lenovo.cloud.framework.common.util.collection.CollectionUtils;
import com.lenovo.cloud.framework.ratelimiter.core.annotation.RateLimiter;
import com.lenovo.cloud.framework.ratelimiter.core.keyresolver.RateLimiterKeyResolver;
import com.lenovo.cloud.framework.ratelimiter.core.redis.RateLimiterRedisDAO;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@Aspect
public class RateLimiterAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RateLimiterAspect.class);
    private final Map<Class<? extends RateLimiterKeyResolver>, RateLimiterKeyResolver> keyResolvers;
    private final RateLimiterRedisDAO rateLimiterRedisDAO;

    public RateLimiterAspect(List<RateLimiterKeyResolver> list, RateLimiterRedisDAO rateLimiterRedisDAO) {
        this.keyResolvers = CollectionUtils.convertMap(list, Object::getClass);
        this.rateLimiterRedisDAO = rateLimiterRedisDAO;
    }

    @Before(value="@annotation(rateLimiter)")
    public void beforePointCut(JoinPoint joinPoint, RateLimiter rateLimiter) {
        RateLimiterKeyResolver rateLimiterKeyResolver = this.keyResolvers.get(rateLimiter.keyResolver());
        Assert.notNull((Object)rateLimiterKeyResolver, (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684 RateLimiterKeyResolver");
        String string = rateLimiterKeyResolver.resolver(joinPoint, rateLimiter);
        boolean bl = this.rateLimiterRedisDAO.tryAcquire(string, rateLimiter.count(), rateLimiter.time(), rateLimiter.timeUnit());
        if (!bl) {
            log.info("[beforePointCut][\u65b9\u6cd5({}) \u53c2\u6570({}) \u8bf7\u6c42\u8fc7\u4e8e\u9891\u7e41]", (Object)joinPoint.getSignature().toString(), (Object)joinPoint.getArgs());
            String string2 = StrUtil.blankToDefault((CharSequence)rateLimiter.message(), (String)GlobalErrorCodeConstants.TOO_MANY_REQUESTS.getMsg());
            throw new ServiceException(GlobalErrorCodeConstants.TOO_MANY_REQUESTS.getCode(), string2);
        }
    }
}

