/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.ratelimiter.core.redis;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RateIntervalUnit;
import org.redisson.api.RateLimiterConfig;
import org.redisson.api.RateType;
import org.redisson.api.RedissonClient;

public class RateLimiterRedisDAO {
    private static final String RATE_LIMITER = "rate_limiter:%s";
    private final RedissonClient redissonClient;

    public Boolean tryAcquire(String string, int n, int n2, TimeUnit timeUnit) {
        RRateLimiter rRateLimiter = this.getRRateLimiter(string, n, n2, timeUnit);
        return rRateLimiter.tryAcquire();
    }

    private static String formatKey(String string) {
        return String.format(RATE_LIMITER, string);
    }

    private RRateLimiter getRRateLimiter(String string, long l, int n, TimeUnit timeUnit) {
        String string2 = RateLimiterRedisDAO.formatKey(string);
        RRateLimiter rRateLimiter = this.redissonClient.getRateLimiter(string2);
        long l2 = timeUnit.toSeconds(n);
        RateLimiterConfig rateLimiterConfig = rRateLimiter.getConfig();
        if (rateLimiterConfig == null) {
            rRateLimiter.trySetRate(RateType.OVERALL, l, l2, RateIntervalUnit.SECONDS);
            return rRateLimiter;
        }
        if (rateLimiterConfig.getRateType() == RateType.OVERALL && Objects.equals(rateLimiterConfig.getRate(), l) && Objects.equals(rateLimiterConfig.getRateInterval(), TimeUnit.SECONDS.toMillis(l2))) {
            return rRateLimiter;
        }
        rRateLimiter.setRate(RateType.OVERALL, l, l2, RateIntervalUnit.SECONDS);
        return rRateLimiter;
    }

    @Generated
    public RateLimiterRedisDAO(RedissonClient redissonClient) {
        this.redissonClient = redissonClient;
    }
}

