/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.signature.core.aop;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.digest.DigestUtil;
import com.lenovo.cloud.framework.common.exception.ServiceException;
import com.lenovo.cloud.framework.common.exception.enums.GlobalErrorCodeConstants;
import com.lenovo.cloud.framework.common.util.servlet.ServletUtils;
import com.lenovo.cloud.framework.signature.core.annotation.ApiSignature;
import com.lenovo.cloud.framework.signature.core.redis.ApiSignatureRedisDAO;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import lombok.Generated;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class ApiSignatureAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiSignatureAspect.class);
    private final ApiSignatureRedisDAO signatureRedisDAO;

    @Before(value="@annotation(signature)")
    public void beforePointCut(JoinPoint joinPoint, ApiSignature apiSignature) {
        if (this.verifySignature(apiSignature, Objects.requireNonNull(ServletUtils.getRequest()))) {
            return;
        }
        log.error("[beforePointCut][\u65b9\u6cd5{} \u53c2\u6570({}) \u7b7e\u540d\u5931\u8d25]", (Object)joinPoint.getSignature().toString(), (Object)joinPoint.getArgs());
        throw new ServiceException(GlobalErrorCodeConstants.BAD_REQUEST.getCode(), StrUtil.blankToDefault((CharSequence)apiSignature.message(), (String)GlobalErrorCodeConstants.BAD_REQUEST.getMsg()));
    }

    public boolean verifySignature(ApiSignature apiSignature, HttpServletRequest httpServletRequest) {
        if (!this.verifyHeaders(apiSignature, httpServletRequest)) {
            return false;
        }
        String string = httpServletRequest.getHeader(apiSignature.appId());
        String string2 = this.signatureRedisDAO.getAppSecret(string);
        Assert.notNull((Object)string2, (String)"[appId({})] \u627e\u4e0d\u5230\u5bf9\u5e94\u7684 appSecret", (Object[])new Object[]{string});
        String string3 = httpServletRequest.getHeader(apiSignature.sign());
        String string4 = this.buildSignatureString(apiSignature, httpServletRequest, string2);
        String string5 = DigestUtil.sha256Hex((String)string4);
        if (ObjUtil.notEqual((Object)string3, (Object)string5)) {
            return false;
        }
        String string6 = httpServletRequest.getHeader(apiSignature.nonce());
        this.signatureRedisDAO.setNonce(string, string6, apiSignature.timeout() * 2, apiSignature.timeUnit());
        return true;
    }

    private boolean verifyHeaders(ApiSignature apiSignature, HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader(apiSignature.appId());
        if (StrUtil.isBlank((CharSequence)string)) {
            return false;
        }
        String string2 = httpServletRequest.getHeader(apiSignature.timestamp());
        if (StrUtil.isBlank((CharSequence)string2)) {
            return false;
        }
        String string3 = httpServletRequest.getHeader(apiSignature.nonce());
        if (StrUtil.length((CharSequence)string3) < 10) {
            return false;
        }
        String string4 = httpServletRequest.getHeader(apiSignature.sign());
        if (StrUtil.isBlank((CharSequence)string4)) {
            return false;
        }
        long l = apiSignature.timeUnit().toMillis(apiSignature.timeout());
        long l2 = Long.parseLong(string2);
        long l3 = Math.abs(System.currentTimeMillis() - l2);
        if (l3 > l) {
            return false;
        }
        return this.signatureRedisDAO.getNonce(string, string3) == null;
    }

    private String buildSignatureString(ApiSignature apiSignature, HttpServletRequest httpServletRequest, String string) {
        SortedMap<String, String> sortedMap = ApiSignatureAspect.getRequestParameterMap(httpServletRequest);
        SortedMap<String, String> sortedMap2 = ApiSignatureAspect.getRequestHeaderMap(apiSignature, httpServletRequest);
        String string2 = StrUtil.nullToDefault((CharSequence)ServletUtils.getBody((HttpServletRequest)httpServletRequest), (String)"");
        return MapUtil.join(sortedMap, (String)"&", (String)"=", (String[])new String[0]) + string2 + MapUtil.join(sortedMap2, (String)"&", (String)"=", (String[])new String[0]) + string;
    }

    private static SortedMap<String, String> getRequestHeaderMap(ApiSignature apiSignature, HttpServletRequest httpServletRequest) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        treeMap.put(apiSignature.appId(), httpServletRequest.getHeader(apiSignature.appId()));
        treeMap.put(apiSignature.timestamp(), httpServletRequest.getHeader(apiSignature.timestamp()));
        treeMap.put(apiSignature.nonce(), httpServletRequest.getHeader(apiSignature.nonce()));
        return treeMap;
    }

    private static SortedMap<String, String> getRequestParameterMap(HttpServletRequest httpServletRequest) {
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (Map.Entry entry : httpServletRequest.getParameterMap().entrySet()) {
            treeMap.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        return treeMap;
    }

    @Generated
    public ApiSignatureAspect(ApiSignatureRedisDAO apiSignatureRedisDAO) {
        this.signatureRedisDAO = apiSignatureRedisDAO;
    }
}

