/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.redis.core;

import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import java.time.Duration;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;

public class TimeoutRedisCacheManager
extends RedisCacheManager {
    private static final String SPLIT = "#";

    public TimeoutRedisCacheManager(RedisCacheWriter redisCacheWriter, RedisCacheConfiguration redisCacheConfiguration) {
        super(redisCacheWriter, redisCacheConfiguration);
    }

    protected RedisCache createRedisCache(String string, RedisCacheConfiguration redisCacheConfiguration) {
        if (StrUtil.isEmpty((CharSequence)string)) {
            return super.createRedisCache(string, redisCacheConfiguration);
        }
        String[] stringArray = StrUtil.splitToArray((CharSequence)string, (CharSequence)SPLIT);
        if (stringArray.length != 2) {
            return super.createRedisCache(string, redisCacheConfiguration);
        }
        if (redisCacheConfiguration != null) {
            String string2 = StrUtil.subBefore((CharSequence)stringArray[1], (CharSequence)":", (boolean)false);
            stringArray[1] = StrUtil.subAfter((CharSequence)stringArray[1], (CharSequence)string2, (boolean)false);
            Duration duration = this.parseDuration(string2);
            redisCacheConfiguration = redisCacheConfiguration.entryTtl(duration);
        }
        return super.createRedisCache(stringArray[0] + stringArray[1], redisCacheConfiguration);
    }

    private Duration parseDuration(String string) {
        String string2;
        switch (string2 = StrUtil.subSuf((CharSequence)string, (int)-1)) {
            case "d": {
                return Duration.ofDays(this.removeDurationSuffix(string));
            }
            case "h": {
                return Duration.ofHours(this.removeDurationSuffix(string));
            }
            case "m": {
                return Duration.ofMinutes(this.removeDurationSuffix(string));
            }
            case "s": {
                return Duration.ofSeconds(this.removeDurationSuffix(string));
            }
        }
        return Duration.ofSeconds(Long.parseLong(string));
    }

    private Long removeDurationSuffix(String string) {
        return NumberUtil.parseLong((String)StrUtil.sub((CharSequence)string, (int)0, (int)(string.length() - 1)));
    }
}

