/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.redis.utils;

import com.google.common.base.Preconditions;
import com.lenovo.cloud.framework.redis.properties.RedisLockProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class RedisLockUtils {
    private static Logger log = LoggerFactory.getLogger(RedisLockUtils.class);
    private StringRedisTemplate stringRedisTemplate;
    private RedisLockProperties redisLockProperties;

    private RedisLockUtils() {
    }

    public RedisLockUtils(StringRedisTemplate stringRedisTemplate, RedisLockProperties redisLockProperties) {
        this.stringRedisTemplate = stringRedisTemplate;
        this.redisLockProperties = redisLockProperties;
    }

    public RedisLockUtils(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }

    public void setStringRedisTemplate(StringRedisTemplate stringRedisTemplate) {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public RedisLockProperties getRedisLockProperties() {
        return this.redisLockProperties;
    }

    public void setRedisLockProperties(RedisLockProperties redisLockProperties) {
        this.redisLockProperties = redisLockProperties;
    }

    public boolean lock(String string, long l) {
        Preconditions.checkArgument((l > System.currentTimeMillis() ? 1 : 0) != 0, (Object)"\u52a0\u9501\u65f6\u957f\u5fc5\u987b\u5927\u4e8e\u5f53\u524d\u65f6\u95f4");
        return this.lock(string, String.valueOf(l));
    }

    public boolean lock(String string) {
        return this.lock(string, "");
    }

    public void unlock(String string) {
        Preconditions.checkNotNull((Object)string, (Object)String.format("%s must be have value!", "key"));
        try {
            string = this.getLockKey(string);
            log.info("unlock key: {}", (Object)string);
            this.stringRedisTemplate.delete((Object)string);
        }
        catch (Exception exception) {
            log.error("redis \u89e3\u9501\u5f02\u5e38:", (Throwable)exception);
        }
    }

    private boolean lock(String string, String string2) {
        String string3;
        Preconditions.checkNotNull((Object)string, (Object)String.format("%s must be have value!", "key"));
        string = this.getLockKey(string);
        log.info("lock key: {}", (Object)string);
        if (StringUtils.isEmpty((Object)string2)) {
            string2 = String.valueOf(System.currentTimeMillis() + this.redisLockProperties.getTimeout());
        }
        if (this.stringRedisTemplate.opsForValue().setIfAbsent((Object)string, (Object)string2).booleanValue()) {
            return true;
        }
        String string4 = (String)this.stringRedisTemplate.opsForValue().get((Object)string);
        return !StringUtils.isEmpty((Object)string4) && Long.parseLong(string4) < System.currentTimeMillis() && !StringUtils.isEmpty((Object)(string3 = (String)this.stringRedisTemplate.opsForValue().getAndSet((Object)string, (Object)string2))) && string3.equals(string4);
    }

    private String getLockKey(String string) {
        return this.redisLockProperties.getPrefix() + string;
    }
}

