/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.rpc.cluster.loadbalance;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.DefaultResponse;
import org.springframework.cloud.client.loadbalancer.EmptyResponse;
import org.springframework.cloud.client.loadbalancer.Request;
import org.springframework.cloud.client.loadbalancer.Response;
import org.springframework.cloud.loadbalancer.core.NoopServiceInstanceListSupplier;
import org.springframework.cloud.loadbalancer.core.ReactorServiceInstanceLoadBalancer;
import org.springframework.cloud.loadbalancer.core.ServiceInstanceListSupplier;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class DevLoadBalancer
implements ReactorServiceInstanceLoadBalancer {
    private static final Logger log = LoggerFactory.getLogger(DevLoadBalancer.class);
    private ObjectProvider<ServiceInstanceListSupplier> serviceInstanceListSupplierProvider;
    private String serviceId;
    private AtomicInteger position;

    public DevLoadBalancer(ObjectProvider<ServiceInstanceListSupplier> objectProvider, String string) throws NoSuchAlgorithmException {
        this(objectProvider, string, SecureRandom.getInstance("SHA1PRNG").nextInt(1000));
    }

    public DevLoadBalancer(ObjectProvider<ServiceInstanceListSupplier> objectProvider, String string, int n) {
        this.serviceInstanceListSupplierProvider = objectProvider;
        this.serviceId = string;
        this.position = new AtomicInteger(n);
    }

    public Mono<Response<ServiceInstance>> choose(Request request) {
        ServiceInstanceListSupplier serviceInstanceListSupplier = (ServiceInstanceListSupplier)this.serviceInstanceListSupplierProvider.getIfAvailable(NoopServiceInstanceListSupplier::new);
        Mono mono = ((Flux)serviceInstanceListSupplier.get()).next().map(list -> this.getInstanceResponse((List<ServiceInstance>)list, request));
        return mono;
    }

    Response<ServiceInstance> getInstanceResponse(List<ServiceInstance> list, Request request) {
        if (CollectionUtils.isEmpty(list)) {
            log.warn("No instance available {}", (Object)this.serviceId);
            return new EmptyResponse();
        }
        Properties properties = System.getProperties();
        Boolean bl = Boolean.valueOf(properties.getProperty("DEV_ENABLED"));
        if (!Objects.isNull(bl) && bl.booleanValue()) {
            String string = properties.getProperty("DEV_IP_PREFIX");
            String[] stringArray = string.split(",");
            ConcurrentHashMap<String, ServiceInstance> concurrentHashMap = new ConcurrentHashMap<String, ServiceInstance>();
            String string2 = null;
            try {
                string2 = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                log.error("\u83b7\u53d6\u672c\u5730Ip\u53d1\u751f\u5f02\u5e38\u8c03\u7528\u7236\u7c7b\u65b9\u6cd5:", (Throwable)unknownHostException);
                return this.roundRobinLoadBalancer(list, request);
            }
            log.debug("loadBalance select ip is:{}", (Object)string2);
            if (StringUtils.hasLength((String)string2)) {
                ArrayList<ServiceInstance> arrayList = new ArrayList<ServiceInstance>();
                String string3 = null;
                for (ServiceInstance serviceInstance2 : list) {
                    if (string2.equals(serviceInstance2.getHost())) {
                        string3 = serviceInstance2.getHost();
                        concurrentHashMap.put(serviceInstance2.getHost(), serviceInstance2);
                    }
                    for (int i = 0; i < stringArray.length; ++i) {
                        if (!serviceInstance2.getHost().contains(stringArray[i])) continue;
                        arrayList.add(serviceInstance2);
                    }
                }
                if (!CollectionUtils.isEmpty(concurrentHashMap) && string3 != null) {
                    log.debug("\u8bf7\u6c42\u672c\u5730IP\uff1a{}", string3);
                    return new DefaultResponse((ServiceInstance)concurrentHashMap.get(string3));
                }
                if (!CollectionUtils.isEmpty(arrayList)) {
                    ServiceInstance serviceInstance2;
                    arrayList.parallelStream().forEach(serviceInstance -> log.debug("\u83b7\u53d6\u5230\u6d4b\u8bd5\u73af\u5883\u76f8\u5173\u7684\u670d\u52a1\u5217\u8868\uff1a{},ip\uff1a{}", (Object)serviceInstance.getInstanceId(), (Object)serviceInstance.getHost()));
                    int n = Math.abs(this.position.incrementAndGet());
                    serviceInstance2 = (ServiceInstance)arrayList.get(n % arrayList.size());
                    log.debug("\u8bf7\u6c42\u670d\u52a1\u5668IP\uff1a{}", (Object)serviceInstance2.getHost());
                    return new DefaultResponse(serviceInstance2);
                }
            }
        }
        return this.roundRobinLoadBalancer(list, request);
    }

    private Response<ServiceInstance> roundRobinLoadBalancer(List<ServiceInstance> list, Request request) {
        log.debug("select roundRobin loadBalance");
        int n = Math.abs(this.position.incrementAndGet());
        ServiceInstance serviceInstance = list.get(n % list.size());
        log.debug("\u4f7f\u7528\u8f6e\u8be2\u7b56\u7565\uff0c\u8bf7\u6c42\u670d\u52a1\u5668IP\uff1a{}", (Object)serviceInstance.getHost());
        return new DefaultResponse(serviceInstance);
    }
}

