/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.rpc.spring.context;

import java.util.Properties;
import org.springframework.beans.BeansException;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.cloud.openfeign.FeignClientsConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@AutoConfigureAfter(value={FeignClientsConfiguration.class})
public class CustomOpenFeignConfigApplicationListener
implements ApplicationListener<ApplicationEvent>,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (ObjectUtils.nullSafeEquals((Object)this.applicationContext, (Object)applicationEvent.getSource())) {
            this.setDevIpPrefix((ConfigurableEnvironment)this.applicationContext.getBean("environment"));
        }
    }

    private void setDevIpPrefix(ConfigurableEnvironment configurableEnvironment) {
        String string = StringUtils.trimWhitespace((String)configurableEnvironment.getProperty("open.feign.consumer.devEnabled"));
        String string2 = String.valueOf(Boolean.FALSE);
        if (StringUtils.hasLength((String)string)) {
            string2 = string;
        }
        String string3 = StringUtils.trimWhitespace((String)configurableEnvironment.getProperty("open.feign.consumer.devIpPrefix"));
        String string4 = "192.168.";
        if (StringUtils.hasLength((String)string3)) {
            string4 = string3;
        }
        Properties properties = System.getProperties();
        properties.put("DEV_ENABLED", string2);
        properties.put("DEV_IP_PREFIX", string4);
    }
}

