/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.operatelog.core.service;

import com.lenovo.cloud.framework.common.enums.UserTypeEnum;
import com.lenovo.cloud.framework.common.util.monitor.TracerUtils;
import com.lenovo.cloud.framework.common.util.servlet.ServletUtils;
import com.lenovo.cloud.framework.security.core.LoginUser;
import com.lenovo.cloud.framework.security.core.util.SecurityFrameworkUtils;
import com.lenovo.cloud.module.system.api.logger.OperateLogApi;
import com.lenovo.cloud.module.system.api.logger.dto.OperateLogCreateReqDTO;
import com.mzt.logapi.beans.LogRecord;
import com.mzt.logapi.service.ILogRecordService;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogRecordServiceImpl
implements ILogRecordService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogRecordServiceImpl.class);
    @Resource
    private OperateLogApi operateLogApi;

    public void record(LogRecord logRecord) {
        OperateLogCreateReqDTO operateLogCreateReqDTO = new OperateLogCreateReqDTO();
        try {
            operateLogCreateReqDTO.setTraceId(TracerUtils.getTraceId());
            LogRecordServiceImpl.fillUserFields(operateLogCreateReqDTO, logRecord.getBizNo());
            LogRecordServiceImpl.fillModuleFields(operateLogCreateReqDTO, logRecord);
            LogRecordServiceImpl.fillRequestFields(operateLogCreateReqDTO);
            this.operateLogApi.createOperateLogAsync(operateLogCreateReqDTO);
        }
        catch (Throwable throwable) {
            log.error("[record][url({}) log({}) \u53d1\u751f\u5f02\u5e38]", new Object[]{operateLogCreateReqDTO.getRequestUrl(), operateLogCreateReqDTO, throwable});
        }
    }

    private static void fillUserFields(OperateLogCreateReqDTO operateLogCreateReqDTO, String string) {
        LoginUser loginUser = SecurityFrameworkUtils.getLoginUser();
        if (loginUser == null) {
            if (StringUtils.isNotEmpty((CharSequence)string)) {
                operateLogCreateReqDTO.setUserId(Long.valueOf(Long.parseLong(string)));
            }
            operateLogCreateReqDTO.setUserType(UserTypeEnum.ADMIN.getValue());
        } else {
            operateLogCreateReqDTO.setUserId(loginUser.getId());
            operateLogCreateReqDTO.setUserType(loginUser.getUserType());
        }
    }

    public static void fillModuleFields(OperateLogCreateReqDTO operateLogCreateReqDTO, LogRecord logRecord) {
        operateLogCreateReqDTO.setType(logRecord.getType());
        operateLogCreateReqDTO.setSubType(logRecord.getSubType());
        operateLogCreateReqDTO.setBizId(Long.valueOf(Long.parseLong(logRecord.getBizNo())));
        operateLogCreateReqDTO.setAction(logRecord.getAction());
        operateLogCreateReqDTO.setExtra(logRecord.getExtra());
    }

    private static void fillRequestFields(OperateLogCreateReqDTO operateLogCreateReqDTO) {
        HttpServletRequest httpServletRequest = ServletUtils.getRequest();
        if (httpServletRequest == null) {
            return;
        }
        operateLogCreateReqDTO.setRequestMethod(httpServletRequest.getMethod());
        operateLogCreateReqDTO.setRequestUrl(httpServletRequest.getRequestURI());
        operateLogCreateReqDTO.setUserIp(ServletUtils.getClientIP((HttpServletRequest)httpServletRequest));
        operateLogCreateReqDTO.setUserAgent(ServletUtils.getUserAgent((HttpServletRequest)httpServletRequest));
    }

    public List<LogRecord> queryLog(String string, String string2) {
        throw new UnsupportedOperationException("\u4f7f\u7528 OperateLogApi \u8fdb\u884c\u64cd\u4f5c\u65e5\u5fd7\u7684\u67e5\u8be2");
    }

    public List<LogRecord> queryLogByBizNo(String string, String string2, String string3) {
        throw new UnsupportedOperationException("\u4f7f\u7528 OperateLogApi \u8fdb\u884c\u64cd\u4f5c\u65e5\u5fd7\u7684\u67e5\u8be2");
    }
}

