/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.security.config;

import com.lenovo.cloud.framework.security.config.LenovoRSAProperties;
import com.lenovo.cloud.framework.security.config.SecurityProperties;
import com.lenovo.cloud.framework.security.core.context.TransmittableThreadLocalSecurityContextHolderStrategy;
import com.lenovo.cloud.framework.security.core.filter.TokenAuthenticationFilter;
import com.lenovo.cloud.framework.security.core.handler.AccessDeniedHandlerImpl;
import com.lenovo.cloud.framework.security.core.handler.AuthenticationEntryPointImpl;
import com.lenovo.cloud.framework.security.core.service.SecurityFrameworkService;
import com.lenovo.cloud.framework.security.core.service.SecurityFrameworkServiceImpl;
import com.lenovo.cloud.framework.security.service.RSAService;
import com.lenovo.cloud.framework.web.core.handler.GlobalExceptionHandler;
import com.lenovo.cloud.module.system.api.oauth2.OAuth2TokenApi;
import com.lenovo.cloud.module.system.api.permission.PermissionApi;
import jakarta.annotation.Resource;
import org.springframework.beans.factory.config.MethodInvokingFactoryBean;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.AccessDeniedHandler;

@AutoConfiguration
@AutoConfigureOrder(value=-1)
@EnableConfigurationProperties(value={SecurityProperties.class, LenovoRSAProperties.class})
@ComponentScan(basePackages={"com.lenovo.cloud.framework.security.dal.redis", "com.lenovo.cloud.framework.security.service"})
public class LenovoSecurityAutoConfiguration {
    @Resource
    private SecurityProperties securityProperties;

    @Bean
    public RSAService rsaService() {
        return new RSAService();
    }

    @Bean
    public AuthenticationEntryPoint authenticationEntryPoint() {
        return new AuthenticationEntryPointImpl();
    }

    @Bean
    public AccessDeniedHandler accessDeniedHandler() {
        return new AccessDeniedHandlerImpl();
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder(this.securityProperties.getPasswordEncoderLength().intValue());
    }

    @Bean
    public TokenAuthenticationFilter authenticationTokenFilter(GlobalExceptionHandler globalExceptionHandler, OAuth2TokenApi oAuth2TokenApi) {
        return new TokenAuthenticationFilter(this.securityProperties, globalExceptionHandler, oAuth2TokenApi);
    }

    @Bean(value={"ss"})
    public SecurityFrameworkService securityFrameworkService(PermissionApi permissionApi) {
        return new SecurityFrameworkServiceImpl(permissionApi);
    }

    @Bean
    public MethodInvokingFactoryBean securityContextHolderMethodInvokingFactoryBean() {
        MethodInvokingFactoryBean methodInvokingFactoryBean = new MethodInvokingFactoryBean();
        methodInvokingFactoryBean.setTargetClass(SecurityContextHolder.class);
        methodInvokingFactoryBean.setTargetMethod("setStrategyName");
        methodInvokingFactoryBean.setArguments(new Object[]{TransmittableThreadLocalSecurityContextHolderStrategy.class.getName()});
        return methodInvokingFactoryBean;
    }
}

