/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.security.config;

import cn.hutool.core.collection.CollUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.lenovo.cloud.framework.common.util.collection.CollectionUtils;
import com.lenovo.cloud.framework.security.config.AuthorizeRequestsCustomizer;
import com.lenovo.cloud.framework.security.config.SecurityProperties;
import com.lenovo.cloud.framework.security.core.filter.TokenAuthenticationFilter;
import com.lenovo.cloud.framework.web.config.WebProperties;
import jakarta.annotation.Resource;
import jakarta.annotation.security.PermitAll;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.Customizer;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.HeadersConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.access.AccessDeniedHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.header.writers.ReferrerPolicyHeaderWriter;
import org.springframework.security.web.header.writers.XXssProtectionHeaderWriter;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.pattern.PathPattern;

@AutoConfiguration
@AutoConfigureOrder(value=-1)
@EnableMethodSecurity(securedEnabled=true)
public class LenovoWebSecurityConfigurerAdapter {
    @Resource
    private WebProperties webProperties;
    @Resource
    private SecurityProperties securityProperties;
    @Resource
    private AuthenticationEntryPoint authenticationEntryPoint;
    @Resource
    private AccessDeniedHandler accessDeniedHandler;
    @Resource
    private TokenAuthenticationFilter authenticationTokenFilter;
    @Resource
    private List<AuthorizeRequestsCustomizer> authorizeRequestsCustomizers;
    @Resource
    private ApplicationContext applicationContext;

    @Bean
    public AuthenticationManager authenticationManagerBean(AuthenticationConfiguration authenticationConfiguration) throws Exception {
        return authenticationConfiguration.getAuthenticationManager();
    }

    @Bean
    protected SecurityFilterChain filterChain(HttpSecurity httpSecurity) throws Exception {
        httpSecurity.cors(Customizer.withDefaults()).csrf(AbstractHttpConfigurer::disable).sessionManagement(sessionManagementConfigurer -> sessionManagementConfigurer.sessionCreationPolicy(SessionCreationPolicy.STATELESS)).headers(headersConfigurer -> headersConfigurer.frameOptions(HeadersConfigurer.FrameOptionsConfig::disable).referrerPolicy(referrerPolicyConfig -> referrerPolicyConfig.policy(ReferrerPolicyHeaderWriter.ReferrerPolicy.STRICT_ORIGIN_WHEN_CROSS_ORIGIN)).frameOptions(frameOptionsConfig -> frameOptionsConfig.deny()).xssProtection(xXssConfig -> xXssConfig.headerValue(XXssProtectionHeaderWriter.HeaderValue.ENABLED)).contentSecurityPolicy(contentSecurityPolicyConfig -> contentSecurityPolicyConfig.policyDirectives("default-src 'self'"))).exceptionHandling(exceptionHandlingConfigurer -> exceptionHandlingConfigurer.authenticationEntryPoint(this.authenticationEntryPoint).accessDeniedHandler(this.accessDeniedHandler));
        Multimap<HttpMethod, String> multimap = this.getPermitAllUrlsFromAnnotations();
        httpSecurity.authorizeHttpRequests(authorizationManagerRequestMatcherRegistry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry.requestMatchers(HttpMethod.GET, new String[]{"/*.html", "/*.css", "/*.js"})).permitAll().requestMatchers(HttpMethod.GET, multimap.get((Object)HttpMethod.GET).toArray(new String[0]))).permitAll().requestMatchers(HttpMethod.POST, multimap.get((Object)HttpMethod.POST).toArray(new String[0]))).permitAll().requestMatchers(HttpMethod.PUT, multimap.get((Object)HttpMethod.PUT).toArray(new String[0]))).permitAll().requestMatchers(HttpMethod.DELETE, multimap.get((Object)HttpMethod.DELETE).toArray(new String[0]))).permitAll().requestMatchers(HttpMethod.HEAD, multimap.get((Object)HttpMethod.HEAD).toArray(new String[0]))).permitAll().requestMatchers(HttpMethod.PATCH, multimap.get((Object)HttpMethod.PATCH).toArray(new String[0]))).permitAll().requestMatchers(this.securityProperties.getPermitAllUrls().toArray(new String[0]))).permitAll()).authorizeHttpRequests(authorizationManagerRequestMatcherRegistry -> this.authorizeRequestsCustomizers.forEach(authorizeRequestsCustomizer -> authorizeRequestsCustomizer.customize(authorizationManagerRequestMatcherRegistry))).authorizeHttpRequests(authorizationManagerRequestMatcherRegistry -> ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)authorizationManagerRequestMatcherRegistry.dispatcherTypeMatchers(new DispatcherType[]{DispatcherType.ASYNC})).permitAll().anyRequest()).authenticated());
        httpSecurity.addFilterBefore((Filter)this.authenticationTokenFilter, UsernamePasswordAuthenticationFilter.class);
        return (SecurityFilterChain)httpSecurity.build();
    }

    private String buildAppApi(String string) {
        return this.webProperties.getAppApi().getPrefix() + string;
    }

    private Multimap<HttpMethod, String> getPermitAllUrlsFromAnnotations() {
        HashMultimap hashMultimap = HashMultimap.create();
        RequestMappingHandlerMapping requestMappingHandlerMapping = (RequestMappingHandlerMapping)this.applicationContext.getBean("requestMappingHandlerMapping");
        Map map = requestMappingHandlerMapping.getHandlerMethods();
        for (Map.Entry entry : map.entrySet()) {
            HandlerMethod handlerMethod = (HandlerMethod)entry.getValue();
            if (!handlerMethod.hasMethodAnnotation(PermitAll.class)) continue;
            HashSet hashSet = new HashSet();
            if (((RequestMappingInfo)entry.getKey()).getPatternsCondition() != null) {
                hashSet.addAll(((RequestMappingInfo)entry.getKey()).getPatternsCondition().getPatterns());
            }
            if (((RequestMappingInfo)entry.getKey()).getPathPatternsCondition() != null) {
                hashSet.addAll(CollectionUtils.convertList((Collection)((RequestMappingInfo)entry.getKey()).getPathPatternsCondition().getPatterns(), PathPattern::getPatternString));
            }
            if (hashSet.isEmpty()) continue;
            Set set = ((RequestMappingInfo)entry.getKey()).getMethodsCondition().getMethods();
            if (CollUtil.isEmpty((Collection)set)) {
                hashMultimap.putAll((Object)HttpMethod.GET, hashSet);
                hashMultimap.putAll((Object)HttpMethod.POST, hashSet);
                hashMultimap.putAll((Object)HttpMethod.PUT, hashSet);
                hashMultimap.putAll((Object)HttpMethod.DELETE, hashSet);
                hashMultimap.putAll((Object)HttpMethod.HEAD, hashSet);
                hashMultimap.putAll((Object)HttpMethod.PATCH, hashSet);
                continue;
            }
            ((RequestMappingInfo)entry.getKey()).getMethodsCondition().getMethods().forEach(arg_0 -> LenovoWebSecurityConfigurerAdapter.lambda$getPermitAllUrlsFromAnnotations$11((Multimap)hashMultimap, hashSet, arg_0));
        }
        return hashMultimap;
    }

    private static /* synthetic */ void lambda$getPermitAllUrlsFromAnnotations$11(Multimap multimap, Set set, RequestMethod requestMethod) {
        switch (requestMethod) {
            case GET: {
                multimap.putAll((Object)HttpMethod.GET, (Iterable)set);
                break;
            }
            case POST: {
                multimap.putAll((Object)HttpMethod.POST, (Iterable)set);
                break;
            }
            case PUT: {
                multimap.putAll((Object)HttpMethod.PUT, (Iterable)set);
                break;
            }
            case DELETE: {
                multimap.putAll((Object)HttpMethod.DELETE, (Iterable)set);
                break;
            }
            case HEAD: {
                multimap.putAll((Object)HttpMethod.HEAD, (Iterable)set);
                break;
            }
            case PATCH: {
                multimap.putAll((Object)HttpMethod.PATCH, (Iterable)set);
            }
        }
    }
}

