/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.security.core.context;

import com.alibaba.ttl.TransmittableThreadLocal;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.util.Assert;

public class TransmittableThreadLocalSecurityContextHolderStrategy
implements SecurityContextHolderStrategy {
    private static final ThreadLocal<SecurityContext> CONTEXT_HOLDER = new TransmittableThreadLocal();

    public void clearContext() {
        CONTEXT_HOLDER.remove();
    }

    public SecurityContext getContext() {
        SecurityContext securityContext = CONTEXT_HOLDER.get();
        if (securityContext == null) {
            securityContext = this.createEmptyContext();
            CONTEXT_HOLDER.set(securityContext);
        }
        return securityContext;
    }

    public void setContext(SecurityContext securityContext) {
        Assert.notNull((Object)securityContext, (String)"Only non-null SecurityContext instances are permitted");
        CONTEXT_HOLDER.set(securityContext);
    }

    public SecurityContext createEmptyContext() {
        return new SecurityContextImpl();
    }
}

