/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.security.core.filter;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.lenovo.cloud.framework.common.exception.ServiceException;
import com.lenovo.cloud.framework.common.pojo.CommonResult;
import com.lenovo.cloud.framework.common.util.json.JsonUtils;
import com.lenovo.cloud.framework.common.util.servlet.ServletUtils;
import com.lenovo.cloud.framework.security.config.SecurityProperties;
import com.lenovo.cloud.framework.security.core.LoginUser;
import com.lenovo.cloud.framework.security.core.util.SecurityFrameworkUtils;
import com.lenovo.cloud.framework.web.core.handler.GlobalExceptionHandler;
import com.lenovo.cloud.framework.web.core.util.WebFrameworkUtils;
import com.lenovo.cloud.module.system.api.oauth2.OAuth2TokenApi;
import com.lenovo.cloud.module.system.api.oauth2.dto.OAuth2AccessTokenCheckRespDTO;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.filter.OncePerRequestFilter;

public class TokenAuthenticationFilter
extends OncePerRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TokenAuthenticationFilter.class);
    private final SecurityProperties securityProperties;
    private final GlobalExceptionHandler globalExceptionHandler;
    private final OAuth2TokenApi oauth2TokenApi;

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        String string;
        LoginUser loginUser = this.buildLoginUserByHeader(httpServletRequest);
        if (loginUser == null && StrUtil.isNotEmpty((CharSequence)(string = SecurityFrameworkUtils.obtainAuthorization(httpServletRequest, this.securityProperties.getTokenHeader(), this.securityProperties.getTokenParameter())))) {
            Integer n = WebFrameworkUtils.getLoginUserType((HttpServletRequest)httpServletRequest);
            try {
                loginUser = this.buildLoginUserByToken(string, n);
                if (loginUser == null) {
                    loginUser = this.mockLoginUser(httpServletRequest, string, n);
                }
            }
            catch (Throwable throwable) {
                CommonResult commonResult = this.globalExceptionHandler.allExceptionHandler(httpServletRequest, throwable);
                ServletUtils.writeJSON((HttpServletResponse)httpServletResponse, (Object)commonResult);
                return;
            }
        }
        if (loginUser != null) {
            SecurityFrameworkUtils.setLoginUser(loginUser, httpServletRequest);
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    private LoginUser buildLoginUserByToken(String string, Integer n) {
        try {
            OAuth2AccessTokenCheckRespDTO oAuth2AccessTokenCheckRespDTO = (OAuth2AccessTokenCheckRespDTO)this.oauth2TokenApi.checkAccessToken(string).getCheckedData();
            if (oAuth2AccessTokenCheckRespDTO == null) {
                return null;
            }
            if (n != null && ObjectUtil.notEqual((Object)oAuth2AccessTokenCheckRespDTO.getUserType(), (Object)n)) {
                throw new AccessDeniedException("\u9519\u8bef\u7684\u7528\u6237\u7c7b\u578b");
            }
            return new LoginUser().setId(oAuth2AccessTokenCheckRespDTO.getUserId()).setUserType(oAuth2AccessTokenCheckRespDTO.getUserType()).setInfo(oAuth2AccessTokenCheckRespDTO.getUserInfo()).setTenantId(oAuth2AccessTokenCheckRespDTO.getTenantId()).setScopes(oAuth2AccessTokenCheckRespDTO.getScopes()).setExpiresTime(oAuth2AccessTokenCheckRespDTO.getExpiresTime());
        }
        catch (ServiceException serviceException) {
            return null;
        }
    }

    private LoginUser mockLoginUser(HttpServletRequest httpServletRequest, String string, Integer n) {
        if (!this.securityProperties.getMockEnable().booleanValue()) {
            return null;
        }
        if (!string.startsWith(this.securityProperties.getMockSecret())) {
            return null;
        }
        Long l = Long.valueOf(string.substring(this.securityProperties.getMockSecret().length()));
        return new LoginUser().setId(l).setUserType(n).setTenantId(WebFrameworkUtils.getTenantId((HttpServletRequest)httpServletRequest));
    }

    private LoginUser buildLoginUserByHeader(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader("login-user");
        if (StrUtil.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            string = URLDecoder.decode(string, StandardCharsets.UTF_8);
            return (LoginUser)JsonUtils.parseObject((String)string, LoginUser.class);
        }
        catch (Exception exception) {
            log.error("[buildLoginUserByHeader][\u89e3\u6790 LoginUser({}) \u53d1\u751f\u5f02\u5e38]", (Object)string, (Object)exception);
            throw exception;
        }
    }

    @Generated
    public TokenAuthenticationFilter(SecurityProperties securityProperties, GlobalExceptionHandler globalExceptionHandler, OAuth2TokenApi oAuth2TokenApi) {
        this.securityProperties = securityProperties;
        this.globalExceptionHandler = globalExceptionHandler;
        this.oauth2TokenApi = oAuth2TokenApi;
    }
}

