/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.security.core.service;

import cn.hutool.core.collection.CollUtil;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.lenovo.cloud.framework.common.core.KeyValue;
import com.lenovo.cloud.framework.common.util.cache.CacheUtils;
import com.lenovo.cloud.framework.security.core.LoginUser;
import com.lenovo.cloud.framework.security.core.service.SecurityFrameworkService;
import com.lenovo.cloud.framework.security.core.util.SecurityFrameworkUtils;
import com.lenovo.cloud.module.system.api.permission.PermissionApi;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public class SecurityFrameworkServiceImpl
implements SecurityFrameworkService {
    private final PermissionApi permissionApi;
    private final LoadingCache<KeyValue<Long, List<String>>, Boolean> hasAnyRolesCache = CacheUtils.buildCache((Duration)Duration.ofMinutes(1L), (CacheLoader)new CacheLoader<KeyValue<Long, List<String>>, Boolean>(){

        public Boolean load(KeyValue<Long, List<String>> keyValue) {
            return (Boolean)SecurityFrameworkServiceImpl.this.permissionApi.hasAnyRoles((Long)keyValue.getKey(), ((List)keyValue.getValue()).toArray(new String[0])).getCheckedData();
        }
    });
    private final LoadingCache<KeyValue<Long, List<String>>, Boolean> hasAnyPermissionsCache = CacheUtils.buildCache((Duration)Duration.ofMinutes(1L), (CacheLoader)new CacheLoader<KeyValue<Long, List<String>>, Boolean>(){

        public Boolean load(KeyValue<Long, List<String>> keyValue) {
            return (Boolean)SecurityFrameworkServiceImpl.this.permissionApi.hasAnyPermissions((Long)keyValue.getKey(), ((List)keyValue.getValue()).toArray(new String[0])).getCheckedData();
        }
    });

    @Override
    public boolean hasPermission(String string) {
        return this.hasAnyPermissions(string);
    }

    @Override
    public boolean hasAnyPermissions(String ... stringArray) {
        Long l = SecurityFrameworkUtils.getLoginUserId();
        if (l == null) {
            return false;
        }
        return (Boolean)this.hasAnyPermissionsCache.get((Object)new KeyValue((Object)l, Arrays.asList(stringArray)));
    }

    @Override
    public boolean hasRole(String string) {
        return this.hasAnyRoles(string);
    }

    @Override
    public boolean hasAnyRoles(String ... stringArray) {
        Long l = SecurityFrameworkUtils.getLoginUserId();
        if (l == null) {
            return false;
        }
        return (Boolean)this.hasAnyRolesCache.get((Object)new KeyValue((Object)l, Arrays.asList(stringArray)));
    }

    @Override
    public boolean hasScope(String string) {
        return this.hasAnyScopes(string);
    }

    @Override
    public boolean hasAnyScopes(String ... stringArray) {
        LoginUser loginUser = SecurityFrameworkUtils.getLoginUser();
        if (loginUser == null) {
            return false;
        }
        return CollUtil.containsAny(loginUser.getScopes(), Arrays.asList(stringArray));
    }

    @Generated
    public SecurityFrameworkServiceImpl(PermissionApi permissionApi) {
        this.permissionApi = permissionApi;
    }
}

