/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.security.core.util;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.lenovo.cloud.framework.security.core.LoginUser;
import com.lenovo.cloud.framework.web.core.util.WebFrameworkUtils;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import org.springframework.lang.Nullable;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.util.StringUtils;

public class SecurityFrameworkUtils {
    public static final String AUTHORIZATION_BEARER = "Bearer";
    public static final String LOGIN_USER_HEADER = "login-user";

    private SecurityFrameworkUtils() {
    }

    public static String obtainAuthorization(HttpServletRequest httpServletRequest, String string, String string2) {
        String string3 = httpServletRequest.getHeader(string);
        if (StrUtil.isEmpty((CharSequence)string3)) {
            string3 = httpServletRequest.getParameter(string2);
        }
        if (!StringUtils.hasText((String)string3)) {
            return null;
        }
        int n = string3.indexOf("Bearer ");
        return n >= 0 ? string3.substring(n + 7).trim() : string3;
    }

    public static Authentication getAuthentication() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        if (securityContext == null) {
            return null;
        }
        return securityContext.getAuthentication();
    }

    @Nullable
    public static LoginUser getLoginUser() {
        Authentication authentication = SecurityFrameworkUtils.getAuthentication();
        if (authentication == null) {
            return null;
        }
        return authentication.getPrincipal() instanceof LoginUser ? (LoginUser)authentication.getPrincipal() : null;
    }

    @Nullable
    public static Long getLoginUserId() {
        LoginUser loginUser = SecurityFrameworkUtils.getLoginUser();
        return loginUser != null ? loginUser.getId() : null;
    }

    @Nullable
    public static String getLoginUserNickname() {
        LoginUser loginUser = SecurityFrameworkUtils.getLoginUser();
        return loginUser != null ? MapUtil.getStr(loginUser.getInfo(), (Object)"nickname") : null;
    }

    @Nullable
    public static Long getLoginUserDeptId() {
        LoginUser loginUser = SecurityFrameworkUtils.getLoginUser();
        return loginUser != null ? MapUtil.getLong(loginUser.getInfo(), (Object)"deptId") : null;
    }

    @Nullable
    public static String getLoginUsername() {
        LoginUser loginUser = SecurityFrameworkUtils.getLoginUser();
        return loginUser != null ? MapUtil.getStr(loginUser.getInfo(), (Object)"username") : null;
    }

    public static void setLoginUser(LoginUser loginUser, HttpServletRequest httpServletRequest) {
        Authentication authentication = SecurityFrameworkUtils.buildAuthentication(loginUser, httpServletRequest);
        SecurityContextHolder.getContext().setAuthentication(authentication);
        WebFrameworkUtils.setLoginUserId((ServletRequest)httpServletRequest, (Long)loginUser.getId());
        WebFrameworkUtils.setLoginUserType((ServletRequest)httpServletRequest, (Integer)loginUser.getUserType());
    }

    private static Authentication buildAuthentication(LoginUser loginUser, HttpServletRequest httpServletRequest) {
        UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)loginUser, null, Collections.emptyList());
        usernamePasswordAuthenticationToken.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(httpServletRequest));
        return usernamePasswordAuthenticationToken;
    }
}

