/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.security.dal.redis;

import com.lenovo.cloud.framework.common.util.encrypt.RSAUtils;
import jakarta.annotation.Resource;
import java.security.KeyPair;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.redisson.api.RBucket;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class RSARedisDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RSARedisDAO.class);
    private static final String RSA_PUBLIC_KEY_KEY = "security:rsa:public_key";
    private static final String RSA_PRIVATE_KEY_KEY = "security:rsa:private_key";
    @Resource
    private RedissonClient redissonClient;

    public KeyPair getKeyPair() {
        try {
            RBucket rBucket = this.redissonClient.getBucket(RSA_PUBLIC_KEY_KEY);
            RBucket rBucket2 = this.redissonClient.getBucket(RSA_PRIVATE_KEY_KEY);
            String string = (String)rBucket.get();
            String string2 = (String)rBucket2.get();
            if (string == null || string2 == null) {
                return null;
            }
            return new KeyPair(RSAUtils.getPublicKey((String)string), RSAUtils.getPrivateKey((String)string2));
        }
        catch (Exception exception) {
            log.error("[getKeyPair][\u4ece Redis \u83b7\u53d6\u5bc6\u94a5\u5bf9\u5931\u8d25]", (Throwable)exception);
            return null;
        }
    }

    public void setKeyPair(KeyPair keyPair, long l, TimeUnit timeUnit) {
        try {
            String string = RSAUtils.getPublicKeyStr((KeyPair)keyPair);
            String string2 = RSAUtils.getPrivateKeyStr((KeyPair)keyPair);
            RBucket rBucket = this.redissonClient.getBucket(RSA_PUBLIC_KEY_KEY);
            RBucket rBucket2 = this.redissonClient.getBucket(RSA_PRIVATE_KEY_KEY);
            rBucket.set((Object)string, l, timeUnit);
            rBucket2.set((Object)string2, l, timeUnit);
        }
        catch (Exception exception) {
            log.error("[setKeyPair][\u8bbe\u7f6e\u5bc6\u94a5\u5bf9\u5230 Redis \u5931\u8d25]", (Throwable)exception);
        }
    }

    public void deleteKeyPair() {
        this.redissonClient.getBucket(RSA_PUBLIC_KEY_KEY).delete();
        this.redissonClient.getBucket(RSA_PRIVATE_KEY_KEY).delete();
    }
}

