/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.security.service;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.StrUtil;
import com.lenovo.cloud.framework.common.util.encrypt.RSAUtils;
import com.lenovo.cloud.framework.security.config.LenovoRSAProperties;
import com.lenovo.cloud.framework.security.dal.redis.RSARedisDAO;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RSAService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RSAService.class);
    @Resource
    private LenovoRSAProperties lenovoRsaProperties;
    @Resource
    private RSARedisDAO rsaRedisDAO;
    private PrivateKey privateKey;
    private PublicKey publicKey;

    @PostConstruct
    public void init() {
        if (!this.lenovoRsaProperties.getEnable().booleanValue()) {
            return;
        }
        if (StrUtil.isNotBlank((CharSequence)this.lenovoRsaProperties.getPrivateKey()) && StrUtil.isNotBlank((CharSequence)this.lenovoRsaProperties.getPublicKey())) {
            this.privateKey = RSAUtils.getPrivateKey((String)this.lenovoRsaProperties.getPrivateKey());
            this.publicKey = RSAUtils.getPublicKey((String)this.lenovoRsaProperties.getPublicKey());
            return;
        }
        KeyPair keyPair = this.rsaRedisDAO.getKeyPair();
        if (keyPair == null) {
            keyPair = RSAUtils.generateKeyPair();
            this.rsaRedisDAO.setKeyPair(keyPair, 24L, TimeUnit.HOURS);
        }
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
    }

    public String getPublicKey() {
        return Base64.encode((byte[])this.publicKey.getEncoded());
    }

    public String decrypt(String string) {
        if (!this.lenovoRsaProperties.getEnable().booleanValue()) {
            return string;
        }
        return RSAUtils.decrypt((String)string, (PrivateKey)this.privateKey);
    }

    public String encrypt(String string) {
        if (!this.lenovoRsaProperties.getEnable().booleanValue()) {
            return string;
        }
        return RSAUtils.encrypt((String)string, (PublicKey)this.publicKey);
    }

    public void refreshKeyPair() {
        KeyPair keyPair = RSAUtils.generateKeyPair();
        this.rsaRedisDAO.setKeyPair(keyPair, 24L, TimeUnit.HOURS);
        this.privateKey = keyPair.getPrivate();
        this.publicKey = keyPair.getPublic();
    }
}

