/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.sequence.config;

import com.lenovo.cloud.framework.sequence.properties.SequenceProperties;
import com.lenovo.cloud.framework.sequence.utils.SequenceUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
@EnableConfigurationProperties(value={SequenceProperties.class})
public class SequenceConfiguration {
    private SequenceProperties sequenceProperties;
    private JdbcTemplate jdbcTemplate;
    private RedisTemplate<String, Object> redisTemplate;

    public SequenceConfiguration(SequenceProperties sequenceProperties, JdbcTemplate jdbcTemplate, RedisTemplate<String, Object> redisTemplate) {
        this.sequenceProperties = sequenceProperties;
        this.jdbcTemplate = jdbcTemplate;
        this.redisTemplate = redisTemplate;
    }

    @Bean
    @ConditionalOnMissingBean
    public SequenceUtils sequenceUtils() {
        return new SequenceUtils(this.redisTemplate, this.jdbcTemplate, this.sequenceProperties);
    }
}

