/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.sequence.utils;

import com.lenovo.cloud.framework.common.util.concurrent.ThreadPoolUtils;
import com.lenovo.cloud.framework.sequence.properties.SequenceProperties;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import redis.clients.jedis.exceptions.JedisDataException;

@Component
public class SequenceUtils
implements InitializingBean,
DisposableBean {
    private static Map<String, String> createSqlMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> insertSqlMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> querySequenceSqlMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> queryMaxSequenceSqlMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> queryGroupSequenceSqlMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> updateSequenceSqlMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> deleteSequenceSqlMap = new ConcurrentHashMap<String, String>();
    private static Map<String, String> dropSequenceSqlMap = new ConcurrentHashMap<String, String>();
    private static Logger log = LoggerFactory.getLogger(SequenceUtils.class);
    private final String ORDERNO_REDIS_KEY = "mall:sequenceNo";
    private Long maxCycle = 1000000L;
    private ExecutorService executorService = null;
    private RedisTemplate<String, Object> redisTemplate;
    private JdbcTemplate jdbcTemplate;
    private SequenceProperties sequenceProperties;
    private final String SEPARATOR = ":";
    private String CREATE_SEQUECENCE_TABLE_SQL = null;
    private String INIT_SEQUECENCE_TABLE_SQL = null;
    private String QUERY_SEQUECENCE_TABLE_SQL = null;
    private String QUERY_MAX_SEQUECENCE_TABLE_SQL = null;
    private String QUERY_GROUP_SEQUECENCE_TABLE_SQL = null;
    private String UPDATE_SEQUECENCE_TABLE_SQL = null;
    private String DELETE_SEQUECENCE_TABLE_SQL = null;
    private String DROP_SEQUECENCE_TABLE_SQL = null;

    public SequenceUtils(RedisTemplate<String, Object> redisTemplate, JdbcTemplate jdbcTemplate, SequenceProperties sequenceProperties) {
        this.redisTemplate = redisTemplate;
        this.jdbcTemplate = jdbcTemplate;
        this.sequenceProperties = sequenceProperties;
    }

    public String generateSequence(String string) {
        return this.generateSequence(string, 8, 0L, "");
    }

    public String generateSequence(String string, String string2) {
        return this.generateSequence(string, 8, string2);
    }

    public String generateSequence(String string, int n, String string2) {
        return this.generateSequence(string, n, 0L, string2);
    }

    private String generateSequence(final String string, int n, long l, String string2) {
        int n2;
        if (ObjectUtils.isEmpty((Object)string)) {
            throw new RuntimeException("\u5e8f\u5217\u53f7key\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if ((long)n <= l) {
            log.error("\u957f\u5ea6\u5c0f\u4e8e\u5f00\u59cb\u503c\uff0c\u5e8f\u5217\u53f7\u751f\u6210\u5931\u8d25!length\uff1a{},start:{}", (Object)n, (Object)l);
            throw new RuntimeException("\u957f\u5ea6\u5c0f\u4e8e\u5f00\u59cb\u503c\uff0c\u5e8f\u5217\u53f7\u751f\u6210\u5931\u8d25!");
        }
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)("mall:sequenceNo:" + string));
        if (boundValueOperations.get() == null) {
            BoundValueOperations boundValueOperations2 = this.redisTemplate.boundValueOps((Object)("mall:sequenceNo:TABLE:LOCK:" + string));
            if (!boundValueOperations2.setIfAbsent((Object)true).booleanValue()) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    log.error("InterruptedException:", (Throwable)interruptedException);
                }
                boundValueOperations2.expire(10L, TimeUnit.SECONDS);
                return this.generateSequence(string, n, l, string2);
            }
            SqlRowSet sqlRowSet = this.jdbcTemplate.queryForRowSet(this.QUERY_SEQUECENCE_TABLE_SQL, new Object[]{string});
            Long l2 = 0L;
            if (sqlRowSet.next()) {
                l2 = sqlRowSet.getLong(1);
            }
            boundValueOperations.set((Object)l2);
        }
        long l3 = System.currentTimeMillis();
        String string3 = null;
        Exception exception = null;
        for (n2 = 0; n2 < 5; ++n2) {
            try {
                final Long l4 = boundValueOperations.increment(1L);
                if (l4 >= this.maxCycle) {
                    BoundValueOperations boundValueOperations3 = this.redisTemplate.boundValueOps((Object)("mall:sequenceNoCIRCULATE:LOCK:" + string));
                    if (boundValueOperations3.setIfAbsent((Object)true).booleanValue()) {
                        boundValueOperations.set((Object)l);
                        boundValueOperations3.expire(300L, TimeUnit.MICROSECONDS);
                        return this.generateSequence(string, n, l, string2);
                    }
                    Thread.sleep(200L);
                    return this.generateSequence(string, n, l, string2);
                }
                string3 = string2 + this.fillLeftZero(l4, n);
                this.executorService.execute(new Runnable(){

                    @Override
                    public void run() {
                        List list = SequenceUtils.this.jdbcTemplate.queryForList(SequenceUtils.this.QUERY_SEQUECENCE_TABLE_SQL, new Object[]{string});
                        if (CollectionUtils.isEmpty((Collection)list)) {
                            BoundValueOperations boundValueOperations = SequenceUtils.this.redisTemplate.boundValueOps((Object)("mall:sequenceNo:INIT:LOCK:" + string));
                            if (boundValueOperations.setIfAbsent((Object)true).booleanValue()) {
                                boundValueOperations.expire(1L, TimeUnit.MINUTES);
                                SequenceUtils.this.jdbcTemplate.update(SequenceUtils.this.INIT_SEQUECENCE_TABLE_SQL, new Object[]{string, l4});
                            } else {
                                try {
                                    Thread.sleep(1000L);
                                }
                                catch (InterruptedException interruptedException) {
                                    log.error("InterruptedException:", (Throwable)interruptedException);
                                }
                                SequenceUtils.this.updateSequence(l4, string);
                            }
                        } else {
                            SequenceUtils.this.updateSequence(l4, string);
                        }
                    }
                });
                break;
            }
            catch (Exception exception2) {
                if (exception2 instanceof JedisDataException) {
                    boundValueOperations.set((Object)0L);
                }
                exception = exception2;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                continue;
            }
        }
        if (n2 >= 5) {
            throw new RuntimeException("\u751f\u6210\u5e8f\u5217\u53f7\u5931\u8d25", exception);
        }
        log.debug("\u751f\u6210\u5e8f\u5217\u53f7\u8017\u65f6\uff1a{} ", (Object)(System.currentTimeMillis() - l3));
        log.info("sequence--->{}", string3);
        return string3;
    }

    private String fillLeftZero(Long l, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(l);
        if (stringBuilder.length() >= n) {
            return stringBuilder.substring(stringBuilder.length() - n);
        }
        for (int i = stringBuilder.length(); i < n; ++i) {
            stringBuilder.insert(0, '0');
        }
        return stringBuilder.toString();
    }

    private void updateSequence(Long l, String string) {
        this.jdbcTemplate.update(this.UPDATE_SEQUECENCE_TABLE_SQL, new Object[]{l, l, this.maxCycle - 1L, string});
    }

    public void destroy() throws Exception {
        this.executorService.shutdown();
    }

    public void afterPropertiesSet() throws Exception {
        List list;
        block6: {
            this.executorService = ThreadPoolUtils.createThreadPool((Integer)3, (String)"\u5e8f\u5217\u53f7\u540c\u6b65");
            String string = this.sequenceProperties.getDatabaseType();
            String string2 = this.sequenceProperties.getTableName();
            log.debug("\u521d\u59cb\u5316sql\u4fe1\u606f\uff0c\u4ee5\u53ca\u8868\u7ed3\u6784");
            if (ObjectUtils.isEmpty((Object)this.sequenceProperties.getDatabaseType()) || ObjectUtils.isEmpty((Object)string2)) {
                throw new RuntimeException("\u6570\u636e\u5e93\u7c7b\u578b\u548c\u8868\u7ed3\u6784\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
            }
            this.CREATE_SEQUECENCE_TABLE_SQL = String.format(createSqlMap.get(string), string2);
            this.INIT_SEQUECENCE_TABLE_SQL = String.format(insertSqlMap.get(string), string2);
            this.QUERY_SEQUECENCE_TABLE_SQL = String.format(querySequenceSqlMap.get(string), string2);
            this.QUERY_MAX_SEQUECENCE_TABLE_SQL = String.format(queryMaxSequenceSqlMap.get(string), string2);
            this.QUERY_GROUP_SEQUECENCE_TABLE_SQL = String.format(queryGroupSequenceSqlMap.get(string), string2);
            this.UPDATE_SEQUECENCE_TABLE_SQL = String.format(updateSequenceSqlMap.get(string), string2);
            this.DELETE_SEQUECENCE_TABLE_SQL = String.format(deleteSequenceSqlMap.get(string), string2);
            this.DROP_SEQUECENCE_TABLE_SQL = String.format(dropSequenceSqlMap.get(string), string2);
            list = null;
            try {
                list = this.jdbcTemplate.queryForList(this.QUERY_GROUP_SEQUECENCE_TABLE_SQL, String.class);
            }
            catch (Exception exception) {
                if (!(exception instanceof BadSqlGrammarException)) break block6;
                try {
                    this.jdbcTemplate.execute(this.DROP_SEQUECENCE_TABLE_SQL);
                }
                catch (Exception exception2) {
                    log.error("Exception:", (Throwable)exception2);
                }
                this.jdbcTemplate.execute(this.CREATE_SEQUECENCE_TABLE_SQL);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)list)) {
            list.forEach(object -> {
                Long l = (Long)this.jdbcTemplate.queryForObject(this.QUERY_MAX_SEQUECENCE_TABLE_SQL, Long.class, new Object[]{object});
                this.jdbcTemplate.update(this.DELETE_SEQUECENCE_TABLE_SQL, new Object[]{object});
                this.jdbcTemplate.update(this.INIT_SEQUECENCE_TABLE_SQL, new Object[]{object, l});
            });
        }
    }

    static {
        createSqlMap.put("h2", "CREATE TABLE %s (sequence_key varchar(255) ,sequence number)");
        createSqlMap.put("mysql", "CREATE TABLE %s (sequence_key varchar(255) ,sequence bigint)");
        createSqlMap.put("informix", "CREATE TABLE %s (sequence_key varchar(255) ,sequence number)");
        createSqlMap.put("oracle", "CREATE TABLE %s (sequence_key varchar(255) ,sequence number)");
        insertSqlMap.put("h2", "insert into %s(sequence_key,sequence) values(?,?)");
        insertSqlMap.put("mysql", "insert into %s(sequence_key,sequence) values(?,?)");
        insertSqlMap.put("informix", "insert into %s(sequence_key,sequence) values(?,?)");
        insertSqlMap.put("oracle", "insert into %s(sequence_key,sequence) values(?,?)");
        querySequenceSqlMap.put("h2", "select sequence from  %s where sequence_key=? ");
        querySequenceSqlMap.put("mysql", "select sequence from  %s where sequence_key=? ");
        querySequenceSqlMap.put("informix", "select sequence from  %s where sequence_key=? ");
        querySequenceSqlMap.put("oracle", "select sequence from  %s where sequence_key=? ");
        queryMaxSequenceSqlMap.put("h2", "select max(sequence) from  %s where sequence_key=? ");
        queryMaxSequenceSqlMap.put("mysql", "select max(sequence) from  %s where sequence_key=? ");
        queryMaxSequenceSqlMap.put("informix", "select max(sequence) from  %s where sequence_key=? ");
        queryMaxSequenceSqlMap.put("oracle", "select max(sequence) from  %s where sequence_key=? ");
        queryGroupSequenceSqlMap.put("h2", "select sequence_key  from   %s group by sequence_key having count(*)>1");
        queryGroupSequenceSqlMap.put("mysql", "select sequence_key  from   %s group by sequence_key having count(*)>1");
        queryGroupSequenceSqlMap.put("informix", "select sequence_key  from   %s group by sequence_key having count(*)>1");
        queryGroupSequenceSqlMap.put("oracle", "select sequence_key  from   %s group by sequence_key having count(*)>1");
        updateSequenceSqlMap.put("h2", "update  %s  set sequence=? where (sequence<? or sequence>=?) and sequence_key=? ");
        updateSequenceSqlMap.put("mysql", "update  %s  set sequence=? where (sequence<? or sequence>=?) and sequence_key=? ");
        updateSequenceSqlMap.put("informix", "update  %s  set sequence=? where (sequence<? or sequence>=?) and sequence_key=? ");
        updateSequenceSqlMap.put("oracle", "update  %s  set sequence=? where (sequence<? or sequence>=?) and sequence_key=? ");
        deleteSequenceSqlMap.put("h2", "delete from  %s where sequence_key=? ");
        deleteSequenceSqlMap.put("mysql", "delete from  %s where sequence_key=? ");
        deleteSequenceSqlMap.put("informix", "delete from  %s where sequence_key=? ");
        deleteSequenceSqlMap.put("oracle", "delete from  %s where sequence_key=? ");
        dropSequenceSqlMap.put("h2", "drop table %s ");
        dropSequenceSqlMap.put("mysql", "drop table %s ");
        dropSequenceSqlMap.put("informix", "drop table %s ");
        dropSequenceSqlMap.put("oracle", "drop table %s ");
    }
}

