/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.test.config;

import javax.sql.DataSource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.autoconfigure.sql.init.SqlInitializationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.jdbc.init.DataSourceScriptDatabaseInitializer;
import org.springframework.boot.sql.init.AbstractScriptDatabaseInitializer;
import org.springframework.boot.sql.init.DatabaseInitializationSettings;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={AbstractScriptDatabaseInitializer.class})
@ConditionalOnSingleCandidate(value=DataSource.class)
@ConditionalOnClass(name={"org.springframework.jdbc.datasource.init.DatabasePopulator"})
@Lazy(value=false)
@EnableConfigurationProperties(value={SqlInitializationProperties.class})
public class SqlInitializationTestConfiguration {
    @Bean
    public DataSourceScriptDatabaseInitializer dataSourceScriptDatabaseInitializer(DataSource dataSource, SqlInitializationProperties sqlInitializationProperties) {
        DatabaseInitializationSettings databaseInitializationSettings = SqlInitializationTestConfiguration.createFrom(sqlInitializationProperties);
        return new DataSourceScriptDatabaseInitializer(dataSource, databaseInitializationSettings);
    }

    static DatabaseInitializationSettings createFrom(SqlInitializationProperties sqlInitializationProperties) {
        DatabaseInitializationSettings databaseInitializationSettings = new DatabaseInitializationSettings();
        databaseInitializationSettings.setSchemaLocations(sqlInitializationProperties.getSchemaLocations());
        databaseInitializationSettings.setDataLocations(sqlInitializationProperties.getDataLocations());
        databaseInitializationSettings.setContinueOnError(sqlInitializationProperties.isContinueOnError());
        databaseInitializationSettings.setSeparator(sqlInitializationProperties.getSeparator());
        databaseInitializationSettings.setEncoding(sqlInitializationProperties.getEncoding());
        databaseInitializationSettings.setMode(sqlInitializationProperties.getMode());
        return databaseInitializationSettings;
    }
}

