/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.test.core.util;

import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReflectUtil;
import com.lenovo.cloud.framework.common.exception.ErrorCode;
import com.lenovo.cloud.framework.common.exception.ServiceException;
import com.lenovo.cloud.framework.common.exception.util.ServiceExceptionUtil;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;

public class AssertUtils {
    public static void assertPojoEquals(Object object, Object object2, String ... stringArray) {
        Field[] fieldArray = ReflectUtil.getFields(object.getClass());
        Arrays.stream(fieldArray).forEach(field -> {
            if (field.isSynthetic()) {
                return;
            }
            if (ArrayUtil.contains((Object[])stringArray, (Object)field.getName())) {
                return;
            }
            Field field2 = ReflectUtil.getField(object2.getClass(), (String)field.getName());
            if (field2 == null) {
                return;
            }
            Assertions.assertEquals((Object)ReflectUtil.getFieldValue((Object)object, (Field)field), (Object)ReflectUtil.getFieldValue((Object)object2, (Field)field2), (String)String.format("Field(%s) \u4e0d\u5339\u914d", field.getName()));
        });
    }

    public static boolean isPojoEquals(Object object, Object object2, String ... stringArray) {
        Field[] fieldArray = ReflectUtil.getFields(object.getClass());
        return Arrays.stream(fieldArray).allMatch(field -> {
            if (ArrayUtil.contains((Object[])stringArray, (Object)field.getName())) {
                return true;
            }
            Field field2 = ReflectUtil.getField(object2.getClass(), (String)field.getName());
            if (field2 == null) {
                return true;
            }
            return Objects.equals(ReflectUtil.getFieldValue((Object)object, (Field)field), ReflectUtil.getFieldValue((Object)object2, (Field)field2));
        });
    }

    public static void assertServiceException(Executable executable, ErrorCode errorCode, Object ... objectArray) {
        ServiceException serviceException = (ServiceException)Assertions.assertThrows(ServiceException.class, (Executable)executable);
        Assertions.assertEquals((Integer)errorCode.getCode(), (Integer)serviceException.getCode(), (String)"\u9519\u8bef\u7801\u4e0d\u5339\u914d");
        String string = ServiceExceptionUtil.doFormat((int)errorCode.getCode(), (String)errorCode.getMsg(), (Object[])objectArray);
        Assertions.assertEquals((Object)string, (Object)serviceException.getMessage(), (String)"\u9519\u8bef\u63d0\u793a\u4e0d\u5339\u914d");
    }
}

