/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.apilog.config;

import com.lenovo.cloud.framework.apilog.core.filter.ApiAccessLogFilter;
import com.lenovo.cloud.framework.apilog.core.interceptor.ApiAccessLogInterceptor;
import com.lenovo.cloud.framework.web.config.LenovoWebAutoConfiguration;
import com.lenovo.cloud.framework.web.config.WebProperties;
import com.lenovo.cloud.module.infra.api.logger.ApiAccessLogApi;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration(after={LenovoWebAutoConfiguration.class})
public class LenovoApiLogAutoConfiguration
implements WebMvcConfigurer {
    @Bean
    @ConditionalOnProperty(prefix="lenovo.access-log", value={"enable"}, matchIfMissing=true)
    public FilterRegistrationBean<ApiAccessLogFilter> apiAccessLogFilter(WebProperties webProperties, @Value(value="${spring.application.name}") String string, ApiAccessLogApi apiAccessLogApi) {
        ApiAccessLogFilter apiAccessLogFilter = new ApiAccessLogFilter(webProperties, string, apiAccessLogApi);
        return LenovoApiLogAutoConfiguration.createFilterBean(apiAccessLogFilter, -103);
    }

    private static <T extends Filter> FilterRegistrationBean<T> createFilterBean(T t, Integer n) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean(t, new ServletRegistrationBean[0]);
        filterRegistrationBean.setOrder(n.intValue());
        return filterRegistrationBean;
    }

    public void addInterceptors(InterceptorRegistry interceptorRegistry) {
        interceptorRegistry.addInterceptor((HandlerInterceptor)new ApiAccessLogInterceptor());
    }
}

