/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.apilog.core.filter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.lenovo.cloud.framework.apilog.core.annotation.ApiAccessLog;
import com.lenovo.cloud.framework.apilog.core.enums.OperateTypeEnum;
import com.lenovo.cloud.framework.common.exception.enums.GlobalErrorCodeConstants;
import com.lenovo.cloud.framework.common.pojo.CommonResult;
import com.lenovo.cloud.framework.common.util.json.JsonUtils;
import com.lenovo.cloud.framework.common.util.monitor.TracerUtils;
import com.lenovo.cloud.framework.common.util.servlet.ServletUtils;
import com.lenovo.cloud.framework.web.config.WebProperties;
import com.lenovo.cloud.framework.web.core.filter.ApiRequestFilter;
import com.lenovo.cloud.framework.web.core.util.WebFrameworkUtils;
import com.lenovo.cloud.module.infra.api.logger.ApiAccessLogApi;
import com.lenovo.cloud.module.infra.api.logger.dto.ApiAccessLogCreateReqDTO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.method.HandlerMethod;

public class ApiAccessLogFilter
extends ApiRequestFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiAccessLogFilter.class);
    private static final String[] SANITIZE_KEYS = new String[]{"password", "token", "accessToken", "refreshToken"};
    private final String applicationName;
    private final ApiAccessLogApi apiAccessLogApi;

    public ApiAccessLogFilter(WebProperties webProperties, String string, ApiAccessLogApi apiAccessLogApi) {
        super(webProperties);
        this.applicationName = string;
        this.apiAccessLogApi = apiAccessLogApi;
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        LocalDateTime localDateTime = LocalDateTime.now();
        Map map = ServletUtils.getParamMap((HttpServletRequest)httpServletRequest);
        String string = ServletUtils.isJsonRequest((ServletRequest)httpServletRequest) ? ServletUtils.getBody((HttpServletRequest)httpServletRequest) : null;
        try {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            this.createApiAccessLog(httpServletRequest, localDateTime, map, string, null);
        }
        catch (Exception exception) {
            this.createApiAccessLog(httpServletRequest, localDateTime, map, string, exception);
            throw exception;
        }
    }

    private void createApiAccessLog(HttpServletRequest httpServletRequest, LocalDateTime localDateTime, Map<String, String> map, String string, Exception exception) {
        ApiAccessLogCreateReqDTO apiAccessLogCreateReqDTO = new ApiAccessLogCreateReqDTO();
        try {
            boolean bl = this.buildApiAccessLog(apiAccessLogCreateReqDTO, httpServletRequest, localDateTime, map, string, exception);
            if (!bl) {
                return;
            }
            this.apiAccessLogApi.createApiAccessLogAsync(apiAccessLogCreateReqDTO);
        }
        catch (Throwable throwable) {
            log.error("[createApiAccessLog][url({}) log({}) \u53d1\u751f\u5f02\u5e38]", new Object[]{httpServletRequest.getRequestURI(), JsonUtils.toJsonString((Object)apiAccessLogCreateReqDTO), throwable});
        }
    }

    private boolean buildApiAccessLog(ApiAccessLogCreateReqDTO apiAccessLogCreateReqDTO, HttpServletRequest httpServletRequest, LocalDateTime localDateTime, Map<String, String> map, String string, Exception exception) {
        Object object;
        HandlerMethod handlerMethod = (HandlerMethod)httpServletRequest.getAttribute("HANDLER_METHOD");
        ApiAccessLog apiAccessLog = null;
        if (handlerMethod != null && (apiAccessLog = (ApiAccessLog)handlerMethod.getMethodAnnotation(ApiAccessLog.class)) != null && BooleanUtil.isFalse((Boolean)apiAccessLog.enable())) {
            return false;
        }
        apiAccessLogCreateReqDTO.setUserId(WebFrameworkUtils.getLoginUserId(httpServletRequest)).setUserType(WebFrameworkUtils.getLoginUserType(httpServletRequest));
        CommonResult<?> commonResult = WebFrameworkUtils.getCommonResult((ServletRequest)httpServletRequest);
        if (commonResult != null) {
            apiAccessLogCreateReqDTO.setResultCode(commonResult.getCode()).setResultMsg(commonResult.getMsg());
        } else if (exception != null) {
            apiAccessLogCreateReqDTO.setResultCode(GlobalErrorCodeConstants.INTERNAL_SERVER_ERROR.getCode()).setResultMsg(ExceptionUtil.getRootCauseMessage((Throwable)exception));
        } else {
            apiAccessLogCreateReqDTO.setResultCode(GlobalErrorCodeConstants.SUCCESS.getCode()).setResultMsg("");
        }
        apiAccessLogCreateReqDTO.setTraceId(TracerUtils.getTraceId()).setApplicationName(this.applicationName).setRequestUrl(httpServletRequest.getRequestURI()).setRequestMethod(httpServletRequest.getMethod()).setUserAgent(ServletUtils.getUserAgent((HttpServletRequest)httpServletRequest)).setUserIp(ServletUtils.getClientIP((HttpServletRequest)httpServletRequest));
        String[] stringArray = apiAccessLog != null ? apiAccessLog.sanitizeKeys() : null;
        Boolean bl = apiAccessLog != null ? apiAccessLog.requestEnable() : Boolean.TRUE.booleanValue();
        if (!BooleanUtil.isFalse((Boolean)bl)) {
            object = MapUtil.builder().put((Object)"query", (Object)ApiAccessLogFilter.sanitizeMap(map, stringArray)).put((Object)"body", (Object)ApiAccessLogFilter.sanitizeJson(string, stringArray)).build();
            apiAccessLogCreateReqDTO.setRequestParams(JsonUtils.toJsonString((Object)object));
        }
        if (BooleanUtil.isTrue((Boolean)(object = Boolean.valueOf(apiAccessLog != null ? apiAccessLog.responseEnable() : Boolean.FALSE.booleanValue())))) {
            apiAccessLogCreateReqDTO.setResponseBody(ApiAccessLogFilter.sanitizeJson(commonResult, stringArray));
        }
        apiAccessLogCreateReqDTO.setBeginTime(localDateTime).setEndTime(LocalDateTime.now()).setDuration(Integer.valueOf((int)LocalDateTimeUtil.between((LocalDateTime)apiAccessLogCreateReqDTO.getBeginTime(), (LocalDateTime)apiAccessLogCreateReqDTO.getEndTime(), (ChronoUnit)ChronoUnit.MILLIS)));
        if (handlerMethod != null) {
            String string2;
            Tag tag = handlerMethod.getBeanType().getAnnotation(Tag.class);
            Operation operation = (Operation)handlerMethod.getMethodAnnotation(Operation.class);
            String string3 = apiAccessLog != null && StrUtil.isNotBlank((CharSequence)apiAccessLog.operateModule()) ? apiAccessLog.operateModule() : (string2 = tag != null ? StrUtil.nullToDefault((CharSequence)tag.name(), (String)tag.description()) : null);
            String string4 = apiAccessLog != null && StrUtil.isNotBlank((CharSequence)apiAccessLog.operateName()) ? apiAccessLog.operateName() : (operation != null ? operation.summary() : null);
            OperateTypeEnum operateTypeEnum = apiAccessLog != null && apiAccessLog.operateType().length > 0 ? apiAccessLog.operateType()[0] : ApiAccessLogFilter.parseOperateLogType(httpServletRequest);
            apiAccessLogCreateReqDTO.setOperateModule(string2).setOperateName(string4).setOperateType(operateTypeEnum.getType());
        }
        return true;
    }

    private static OperateTypeEnum parseOperateLogType(HttpServletRequest httpServletRequest) {
        RequestMethod requestMethod = RequestMethod.resolve((String)httpServletRequest.getMethod());
        if (requestMethod == null) {
            return OperateTypeEnum.OTHER;
        }
        switch (requestMethod) {
            case GET: {
                return OperateTypeEnum.GET;
            }
            case POST: {
                return OperateTypeEnum.CREATE;
            }
            case PUT: {
                return OperateTypeEnum.UPDATE;
            }
            case DELETE: {
                return OperateTypeEnum.DELETE;
            }
        }
        return OperateTypeEnum.OTHER;
    }

    private static String sanitizeMap(Map<String, ?> map, String[] stringArray) {
        if (CollUtil.isEmpty(map)) {
            return null;
        }
        if (stringArray != null) {
            MapUtil.removeAny(map, (Object[])stringArray);
        }
        MapUtil.removeAny(map, (Object[])SANITIZE_KEYS);
        return JsonUtils.toJsonString(map);
    }

    private static String sanitizeJson(String string, String[] stringArray) {
        if (StrUtil.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            JsonNode jsonNode = JsonUtils.parseTree((String)string);
            ApiAccessLogFilter.sanitizeJson(jsonNode, stringArray);
            return JsonUtils.toJsonString((Object)jsonNode);
        }
        catch (Exception exception) {
            log.error("[sanitizeJson][\u8131\u654f({}) \u53d1\u751f\u5f02\u5e38]", (Object)string, (Object)exception);
            return string;
        }
    }

    private static String sanitizeJson(CommonResult<?> commonResult, String[] stringArray) {
        if (commonResult == null) {
            return null;
        }
        String string = JsonUtils.toJsonString(commonResult);
        try {
            JsonNode jsonNode = JsonUtils.parseTree((String)string);
            ApiAccessLogFilter.sanitizeJson(jsonNode.get("data"), stringArray);
            return JsonUtils.toJsonString((Object)jsonNode);
        }
        catch (Exception exception) {
            log.error("[sanitizeJson][\u8131\u654f({}) \u53d1\u751f\u5f02\u5e38]", (Object)string, (Object)exception);
            return string;
        }
    }

    private static void sanitizeJson(JsonNode jsonNode, String[] stringArray) {
        if (jsonNode.isArray()) {
            for (JsonNode jsonNode2 : jsonNode) {
                ApiAccessLogFilter.sanitizeJson(jsonNode2, stringArray);
            }
            return;
        }
        if (!jsonNode.isObject()) {
            return;
        }
        Iterator iterator = jsonNode.properties().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (ArrayUtil.contains((Object[])stringArray, (Object)((String)entry.getKey())) || ArrayUtil.contains((Object[])SANITIZE_KEYS, (Object)((String)entry.getKey()))) {
                iterator.remove();
                continue;
            }
            ApiAccessLogFilter.sanitizeJson((JsonNode)entry.getValue(), stringArray);
        }
    }
}

