/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.apilog.core.interceptor;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.StrUtil;
import com.lenovo.cloud.framework.common.util.servlet.ServletUtils;
import com.lenovo.cloud.framework.common.util.spring.SpringUtils;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StopWatch;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class ApiAccessLogInterceptor
implements HandlerInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiAccessLogInterceptor.class);
    public static final String ATTRIBUTE_HANDLER_METHOD = "HANDLER_METHOD";
    private static final String ATTRIBUTE_STOP_WATCH = "ApiAccessLogInterceptor.StopWatch";

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) {
        HandlerMethod handlerMethod;
        HandlerMethod handlerMethod2 = handlerMethod = object instanceof HandlerMethod ? (HandlerMethod)object : null;
        if (handlerMethod != null) {
            httpServletRequest.setAttribute(ATTRIBUTE_HANDLER_METHOD, (Object)handlerMethod);
        }
        if (!SpringUtils.isProd()) {
            String string;
            Map map = ServletUtils.getParamMap((HttpServletRequest)httpServletRequest);
            String string2 = string = ServletUtils.isJsonRequest((ServletRequest)httpServletRequest) ? ServletUtils.getBody((HttpServletRequest)httpServletRequest) : null;
            if (CollUtil.isEmpty((Map)map) && StrUtil.isEmpty((CharSequence)string)) {
                log.info("[preHandle][\u5f00\u59cb\u8bf7\u6c42 URL({}) \u65e0\u53c2\u6570]", (Object)httpServletRequest.getRequestURI());
            } else {
                log.info("[preHandle][\u5f00\u59cb\u8bf7\u6c42 URL({}) \u53c2\u6570({})]", (Object)httpServletRequest.getRequestURI(), (Object)StrUtil.blankToDefault((CharSequence)string, (String)map.toString()));
            }
            StopWatch stopWatch = new StopWatch();
            stopWatch.start();
            httpServletRequest.setAttribute(ATTRIBUTE_STOP_WATCH, (Object)stopWatch);
            this.printHandlerMethodPosition(handlerMethod);
        }
        return true;
    }

    public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object, Exception exception) {
        if (!SpringUtils.isProd()) {
            StopWatch stopWatch = (StopWatch)httpServletRequest.getAttribute(ATTRIBUTE_STOP_WATCH);
            stopWatch.stop();
            log.info("[afterCompletion][\u5b8c\u6210\u8bf7\u6c42 URL({}) \u8017\u65f6({} ms)]", (Object)httpServletRequest.getRequestURI(), (Object)stopWatch.getTotalTimeMillis());
        }
    }

    private void printHandlerMethodPosition(HandlerMethod handlerMethod) {
        if (handlerMethod == null) {
            return;
        }
        Method method = handlerMethod.getMethod();
        Class<?> clazz = method.getDeclaringClass();
        try {
            List list = FileUtil.readUtf8Lines((String)(ResourceUtil.getResource(null, clazz).getPath().replace("/target/classes/", "/src/main/java/") + clazz.getSimpleName() + ".java"));
            Optional<Integer> optional = IntStream.range(0, list.size()).filter(n -> ((String)list.get(n)).contains(" " + method.getName() + "(")).mapToObj(n -> n + 1).findFirst();
            if (!optional.isPresent()) {
                return;
            }
            System.out.printf("\tController \u65b9\u6cd5\u8def\u5f84\uff1a%s(%s.java:%d)\n", clazz.getName(), clazz.getSimpleName(), optional.get());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

