/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.desensitize.core.base.serializer;

import cn.hutool.core.annotation.AnnotationUtil;
import cn.hutool.core.lang.Singleton;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.lenovo.cloud.framework.desensitize.core.base.annotation.DesensitizeBy;
import com.lenovo.cloud.framework.desensitize.core.base.handler.DesensitizationHandler;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import lombok.Generated;

public class StringDesensitizeSerializer
extends StdSerializer<String>
implements ContextualSerializer {
    private DesensitizationHandler desensitizationHandler;

    protected StringDesensitizeSerializer() {
        super(String.class);
    }

    public JsonSerializer<?> createContextual(SerializerProvider serializerProvider, BeanProperty beanProperty) {
        DesensitizeBy desensitizeBy = (DesensitizeBy)beanProperty.getAnnotation(DesensitizeBy.class);
        if (desensitizeBy == null) {
            return this;
        }
        StringDesensitizeSerializer stringDesensitizeSerializer = new StringDesensitizeSerializer();
        stringDesensitizeSerializer.setDesensitizationHandler((DesensitizationHandler)Singleton.get(desensitizeBy.handler(), (Object[])new Object[0]));
        return stringDesensitizeSerializer;
    }

    public void serialize(String string, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (StrUtil.isBlank((CharSequence)string)) {
            jsonGenerator.writeNull();
            return;
        }
        Field field = this.getField(jsonGenerator);
        Object[] objectArray = (DesensitizeBy[])AnnotationUtil.getCombinationAnnotations((AnnotatedElement)field, DesensitizeBy.class);
        if (ArrayUtil.isEmpty((Object[])objectArray)) {
            jsonGenerator.writeString(string);
            return;
        }
        for (Annotation annotation : field.getAnnotations()) {
            if (!AnnotationUtil.hasAnnotation(annotation.annotationType(), DesensitizeBy.class)) continue;
            string = this.desensitizationHandler.desensitize(string, annotation);
            jsonGenerator.writeString(string);
            return;
        }
        jsonGenerator.writeString(string);
    }

    private Field getField(JsonGenerator jsonGenerator) {
        String string = jsonGenerator.getOutputContext().getCurrentName();
        Object object = jsonGenerator.getCurrentValue();
        Class<?> clazz = object.getClass();
        return ReflectUtil.getField(clazz, (String)string);
    }

    @Generated
    public DesensitizationHandler getDesensitizationHandler() {
        return this.desensitizationHandler;
    }

    @Generated
    public StringDesensitizeSerializer setDesensitizationHandler(DesensitizationHandler desensitizationHandler) {
        this.desensitizationHandler = desensitizationHandler;
        return this;
    }
}

