/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.swagger.config;

import com.lenovo.cloud.framework.swagger.config.SwaggerProperties;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.info.Contact;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.info.License;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springdoc.core.customizers.OpenApiBuilderCustomizer;
import org.springdoc.core.customizers.ServerBaseUrlCustomizer;
import org.springdoc.core.models.GroupedOpenApi;
import org.springdoc.core.properties.SpringDocConfigProperties;
import org.springdoc.core.providers.JavadocProvider;
import org.springdoc.core.service.OpenAPIService;
import org.springdoc.core.service.SecurityService;
import org.springdoc.core.utils.PropertyResolverUtils;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;

@AutoConfiguration
@ConditionalOnClass(value={OpenAPI.class})
@EnableConfigurationProperties(value={SwaggerProperties.class})
@ConditionalOnProperty(prefix="springdoc.api-docs", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class LenovoSwaggerAutoConfiguration {
    @Bean
    public OpenAPI createApi(SwaggerProperties swaggerProperties) {
        Map<String, SecurityScheme> map = this.buildSecuritySchemes();
        OpenAPI openAPI = new OpenAPI().info(this.buildInfo(swaggerProperties)).components(new Components().securitySchemes(map)).addSecurityItem(new SecurityRequirement().addList("Authorization"));
        map.keySet().forEach(string -> openAPI.addSecurityItem(new SecurityRequirement().addList(string)));
        return openAPI;
    }

    private Info buildInfo(SwaggerProperties swaggerProperties) {
        return new Info().title(swaggerProperties.getTitle()).description(swaggerProperties.getDescription()).version(swaggerProperties.getVersion()).contact(new Contact().name(swaggerProperties.getAuthor()).url(swaggerProperties.getUrl()).email(swaggerProperties.getEmail())).license(new License().name(swaggerProperties.getLicense()).url(swaggerProperties.getLicenseUrl()));
    }

    private Map<String, SecurityScheme> buildSecuritySchemes() {
        HashMap<String, SecurityScheme> hashMap = new HashMap<String, SecurityScheme>();
        SecurityScheme securityScheme = new SecurityScheme().type(SecurityScheme.Type.APIKEY).name("Authorization").in(SecurityScheme.In.HEADER);
        hashMap.put("Authorization", securityScheme);
        return hashMap;
    }

    @Bean
    @Primary
    public OpenAPIService openApiBuilder(Optional<OpenAPI> optional, SecurityService securityService, SpringDocConfigProperties springDocConfigProperties, PropertyResolverUtils propertyResolverUtils, Optional<List<OpenApiBuilderCustomizer>> optional2, Optional<List<ServerBaseUrlCustomizer>> optional3, Optional<JavadocProvider> optional4) {
        return new OpenAPIService(optional, securityService, springDocConfigProperties, propertyResolverUtils, optional2, optional3, optional4);
    }

    @Bean
    public GroupedOpenApi allGroupedOpenApi() {
        return LenovoSwaggerAutoConfiguration.buildGroupedOpenApi("all", "");
    }

    public static GroupedOpenApi buildGroupedOpenApi(String string) {
        return LenovoSwaggerAutoConfiguration.buildGroupedOpenApi(string, string);
    }

    public static GroupedOpenApi buildGroupedOpenApi(String string, String string2) {
        return GroupedOpenApi.builder().group(string).pathsToMatch(new String[]{"/admin-api/" + string2 + "/**", "/app-api/" + string2 + "/**"}).addOperationCustomizer((operation, handlerMethod) -> operation.addParametersItem(LenovoSwaggerAutoConfiguration.buildTenantHeaderParameter()).addParametersItem(LenovoSwaggerAutoConfiguration.buildSecurityHeaderParameter())).build();
    }

    private static Parameter buildTenantHeaderParameter() {
        return new Parameter().name("tenant-id").description("\u79df\u6237\u7f16\u53f7").in(String.valueOf(SecurityScheme.In.HEADER)).schema(new IntegerSchema()._default((Number)1L).name("tenant-id").description("\u79df\u6237\u7f16\u53f7"));
    }

    private static Parameter buildSecurityHeaderParameter() {
        return new Parameter().name("Authorization").description("\u8ba4\u8bc1 Token").in(String.valueOf(SecurityScheme.In.HEADER)).schema(new StringSchema()._default("Bearer admin").name("tenant-id").description("\u8ba4\u8bc1 Token"));
    }
}

