/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.web.config;

import com.lenovo.cloud.framework.web.config.WebProperties;
import com.lenovo.cloud.framework.web.core.filter.CacheRequestBodyFilter;
import com.lenovo.cloud.framework.web.core.filter.DemoFilter;
import com.lenovo.cloud.framework.web.core.handler.GlobalExceptionHandler;
import com.lenovo.cloud.framework.web.core.handler.GlobalResponseBodyHandler;
import com.lenovo.cloud.framework.web.core.util.WebFrameworkUtils;
import com.lenovo.cloud.module.infra.api.logger.ApiErrorLogApi;
import jakarta.annotation.Resource;
import jakarta.servlet.Filter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
@EnableConfigurationProperties(value={WebProperties.class})
public class LenovoWebAutoConfiguration
implements WebMvcConfigurer {
    @Resource
    private WebProperties webProperties;
    @Value(value="${spring.application.name}")
    private String applicationName;

    public void configurePathMatch(PathMatchConfigurer pathMatchConfigurer) {
        this.configurePathMatch(pathMatchConfigurer, this.webProperties.getAdminApi());
        this.configurePathMatch(pathMatchConfigurer, this.webProperties.getAppApi());
    }

    private void configurePathMatch(PathMatchConfigurer pathMatchConfigurer, WebProperties.Api api) {
        AntPathMatcher antPathMatcher = new AntPathMatcher(".");
        pathMatchConfigurer.addPathPrefix(api.getPrefix(), clazz -> clazz.isAnnotationPresent(RestController.class) && antPathMatcher.match(api.getController(), clazz.getPackage().getName()));
    }

    @Bean
    public GlobalExceptionHandler globalExceptionHandler(ApiErrorLogApi apiErrorLogApi) {
        return new GlobalExceptionHandler(this.applicationName, apiErrorLogApi);
    }

    @Bean
    public GlobalResponseBodyHandler globalResponseBodyHandler() {
        return new GlobalResponseBodyHandler();
    }

    @Bean
    public WebFrameworkUtils webFrameworkUtils(WebProperties webProperties) {
        return new WebFrameworkUtils(webProperties);
    }

    @Bean
    public FilterRegistrationBean<CorsFilter> corsFilterBean() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.setAllowCredentials(Boolean.valueOf(true));
        corsConfiguration.addAllowedOriginPattern("*");
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        UrlBasedCorsConfigurationSource urlBasedCorsConfigurationSource = new UrlBasedCorsConfigurationSource();
        urlBasedCorsConfigurationSource.registerCorsConfiguration("/**", corsConfiguration);
        return LenovoWebAutoConfiguration.createFilterBean(new CorsFilter((CorsConfigurationSource)urlBasedCorsConfigurationSource), Integer.MIN_VALUE);
    }

    @Bean
    public FilterRegistrationBean<CacheRequestBodyFilter> requestBodyCacheFilter() {
        return LenovoWebAutoConfiguration.createFilterBean(new CacheRequestBodyFilter(), -2147483148);
    }

    @Bean
    @ConditionalOnProperty(value={"lenovo.demo"}, havingValue="true")
    public FilterRegistrationBean<DemoFilter> demoFilter() {
        return LenovoWebAutoConfiguration.createFilterBean(new DemoFilter(), Integer.MAX_VALUE);
    }

    public static <T extends Filter> FilterRegistrationBean<T> createFilterBean(T t, Integer n) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean(t, new ServletRegistrationBean[0]);
        filterRegistrationBean.setOrder(n.intValue());
        return filterRegistrationBean;
    }

    @Bean
    @ConditionalOnMissingBean
    public RestTemplate restTemplate(RestTemplateBuilder restTemplateBuilder) {
        return restTemplateBuilder.build();
    }
}

