/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.web.core.I18n;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.LocaleResolver;

public class I18nLocaleResolver
implements LocaleResolver {
    private static final Logger log = LoggerFactory.getLogger(I18nLocaleResolver.class);
    private final Map<String, Locale> localeCache = new ConcurrentHashMap<String, Locale>();
    private static final int MAX_CACHE_SIZE = 100;

    public Locale resolveLocale(HttpServletRequest httpServletRequest) {
        log.debug("[I18nLocaleResolver] resolveLocale \u65b9\u6cd5\u88ab\u8c03\u7528");
        String string = httpServletRequest.getHeader("Content-Language");
        log.debug("[I18nLocaleResolver] Content-Language: {}", (Object)string);
        if (string == null || string.isEmpty()) {
            log.debug("[I18nLocaleResolver] \u672a\u63d0\u4f9bContent-Language, \u4f7f\u7528\u9ed8\u8ba4Locale: {}", (Object)Locale.getDefault());
            return Locale.getDefault();
        }
        if (this.localeCache.containsKey(string)) {
            Locale locale = this.localeCache.get(string);
            log.debug("[I18nLocaleResolver] \u4ece\u7f13\u5b58\u83b7\u53d6Locale: {}", (Object)locale);
            return locale;
        }
        Locale locale = this.parseLocale(string);
        if (this.localeCache.size() >= 100) {
            log.debug("[I18nLocaleResolver] \u7f13\u5b58\u8fbe\u5230\u4e0a\u9650\uff0c\u6e05\u7a7a\u7f13\u5b58");
            this.localeCache.clear();
        }
        this.localeCache.put(string, locale);
        log.debug("[I18nLocaleResolver] \u5c06Locale: {} \u5b58\u5165\u7f13\u5b58", (Object)locale);
        return locale;
    }

    private Locale parseLocale(String string) {
        Locale locale = Locale.getDefault();
        try {
            String[] stringArray;
            String[] stringArray2 = stringArray = string.contains("_") ? string.split("_") : string.split("-");
            if (stringArray.length == 2) {
                locale = new Locale(stringArray[0], stringArray[1]);
            } else if (stringArray.length == 1) {
                locale = new Locale(stringArray[0]);
            }
            log.debug("[I18nLocaleResolver] \u89e3\u6790\u540e\u7684Locale: {}", (Object)locale);
        }
        catch (Exception exception) {
            log.warn("[I18nLocaleResolver] \u89e3\u6790Locale\u5f02\u5e38", (Throwable)exception);
        }
        return locale;
    }

    public void setLocale(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale locale) {
        log.debug("[I18nLocaleResolver] setLocale \u65b9\u6cd5\u88ab\u8c03\u7528\uff0c\u4f46\u4e0d\u652f\u6301\u6b64\u64cd\u4f5c");
    }
}

