/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.web.core.filter;

import com.lenovo.cloud.framework.common.util.servlet.ServletUtils;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public class CacheRequestBodyWrapper
extends HttpServletRequestWrapper {
    private final byte[] body;

    public CacheRequestBodyWrapper(HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
        this.body = ServletUtils.getBodyBytes((HttpServletRequest)httpServletRequest);
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body);
        return new ServletInputStream(){

            public int read() {
                return byteArrayInputStream.read();
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int available() {
                return CacheRequestBodyWrapper.this.body.length;
            }
        };
    }
}

