/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.web.core.handler;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.exceptions.ExceptionUtil;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.servlet.JakartaServletUtil;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.lenovo.cloud.framework.common.exception.ErrorCode;
import com.lenovo.cloud.framework.common.exception.ServerException;
import com.lenovo.cloud.framework.common.exception.ServiceException;
import com.lenovo.cloud.framework.common.exception.enums.GlobalErrorCodeConstants;
import com.lenovo.cloud.framework.common.exception.util.ServiceExceptionUtil;
import com.lenovo.cloud.framework.common.pojo.CommonResult;
import com.lenovo.cloud.framework.common.util.collection.SetUtils;
import com.lenovo.cloud.framework.common.util.json.JsonUtils;
import com.lenovo.cloud.framework.common.util.message.MessageUtils;
import com.lenovo.cloud.framework.common.util.monitor.TracerUtils;
import com.lenovo.cloud.framework.common.util.servlet.ServletUtils;
import com.lenovo.cloud.framework.web.core.util.WebFrameworkUtils;
import com.lenovo.cloud.module.infra.api.logger.ApiErrorLogApi;
import com.lenovo.cloud.module.infra.api.logger.dto.ApiErrorLogCreateReqDTO;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.ValidationException;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.util.Assert;
import org.springframework.validation.BindException;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.method.annotation.MethodArgumentTypeMismatchException;
import org.springframework.web.servlet.NoHandlerFoundException;
import org.springframework.web.servlet.resource.NoResourceFoundException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);
    public static final Set<String> IGNORE_ERROR_MESSAGES = SetUtils.asSet((Object[])new String[]{"\u65e0\u6548\u7684\u5237\u65b0\u4ee4\u724c"});
    private final String applicationName;
    private final ApiErrorLogApi apiErrorLogApi;

    public CommonResult<?> allExceptionHandler(HttpServletRequest httpServletRequest, Throwable throwable) {
        if (throwable instanceof MissingServletRequestParameterException) {
            return this.missingServletRequestParameterExceptionHandler((MissingServletRequestParameterException)throwable);
        }
        if (throwable instanceof MethodArgumentTypeMismatchException) {
            return this.methodArgumentTypeMismatchExceptionHandler((MethodArgumentTypeMismatchException)throwable);
        }
        if (throwable instanceof MethodArgumentNotValidException) {
            return this.methodArgumentNotValidExceptionExceptionHandler((MethodArgumentNotValidException)throwable);
        }
        if (throwable instanceof BindException) {
            return this.bindExceptionHandler((BindException)throwable);
        }
        if (throwable instanceof ConstraintViolationException) {
            return this.constraintViolationExceptionHandler((ConstraintViolationException)throwable);
        }
        if (throwable instanceof ValidationException) {
            return this.validationException((ValidationException)throwable);
        }
        if (throwable instanceof NoHandlerFoundException) {
            return this.noHandlerFoundExceptionHandler((NoHandlerFoundException)throwable);
        }
        if (throwable instanceof NoResourceFoundException) {
            return this.noResourceFoundExceptionHandler(httpServletRequest, (NoResourceFoundException)throwable);
        }
        if (throwable instanceof HttpRequestMethodNotSupportedException) {
            return this.httpRequestMethodNotSupportedExceptionHandler((HttpRequestMethodNotSupportedException)throwable);
        }
        if (throwable instanceof ServiceException) {
            return this.serviceExceptionHandler((ServiceException)throwable);
        }
        if (throwable instanceof AccessDeniedException) {
            return this.accessDeniedExceptionHandler(httpServletRequest, (AccessDeniedException)throwable);
        }
        return this.defaultExceptionHandler(httpServletRequest, throwable);
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public CommonResult<?> missingServletRequestParameterExceptionHandler(MissingServletRequestParameterException missingServletRequestParameterException) {
        log.warn("[missingServletRequestParameterExceptionHandler]", (Throwable)missingServletRequestParameterException);
        return CommonResult.error((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)MessageUtils.message((String)"system.missing.servlet.request.parameter", (Object[])new Object[]{missingServletRequestParameterException.getParameterName()}));
    }

    @ExceptionHandler(value={MethodArgumentTypeMismatchException.class})
    public CommonResult<?> methodArgumentTypeMismatchExceptionHandler(MethodArgumentTypeMismatchException methodArgumentTypeMismatchException) {
        log.warn("[methodArgumentTypeMismatchExceptionHandler]", (Throwable)methodArgumentTypeMismatchException);
        return CommonResult.error((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)MessageUtils.message((String)"system.method.argument.type.mismatch", (Object[])new Object[]{methodArgumentTypeMismatchException.getMessage()}));
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public CommonResult<?> methodArgumentNotValidExceptionExceptionHandler(MethodArgumentNotValidException methodArgumentNotValidException) {
        log.warn("[methodArgumentNotValidExceptionExceptionHandler]", (Throwable)methodArgumentNotValidException);
        String string = null;
        FieldError fieldError = methodArgumentNotValidException.getBindingResult().getFieldError();
        if (fieldError == null) {
            List list = methodArgumentNotValidException.getBindingResult().getAllErrors();
            if (CollUtil.isNotEmpty((Collection)list)) {
                string = ((ObjectError)list.get(0)).getDefaultMessage();
            }
        } else {
            string = fieldError.getDefaultMessage();
        }
        if (StrUtil.isEmpty((CharSequence)string)) {
            return CommonResult.error((ErrorCode)GlobalErrorCodeConstants.BAD_REQUEST);
        }
        return CommonResult.error((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)MessageUtils.message((String)"system.method.argument.not.valid", (Object[])new Object[]{fieldError.getDefaultMessage()}));
    }

    @ExceptionHandler(value={BindException.class})
    public CommonResult<?> bindExceptionHandler(BindException bindException) {
        log.warn("[handleBindException]", (Throwable)bindException);
        FieldError fieldError = bindException.getFieldError();
        assert (fieldError != null);
        return CommonResult.error((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)MessageUtils.message((String)"system.bind.exception", (Object[])new Object[]{fieldError.getDefaultMessage()}));
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public CommonResult<?> methodArgumentTypeInvalidFormatExceptionHandler(HttpMessageNotReadableException httpMessageNotReadableException) {
        log.warn("[methodArgumentTypeInvalidFormatExceptionHandler]", (Throwable)httpMessageNotReadableException);
        if (httpMessageNotReadableException.getCause() instanceof InvalidFormatException) {
            InvalidFormatException invalidFormatException = (InvalidFormatException)httpMessageNotReadableException.getCause();
            return CommonResult.error((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)MessageUtils.message((String)"system.method.argument.type.mismatch", (Object[])new Object[]{invalidFormatException.getValue()}));
        }
        return this.defaultExceptionHandler(ServletUtils.getRequest(), (Throwable)httpMessageNotReadableException);
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public CommonResult<?> constraintViolationExceptionHandler(ConstraintViolationException constraintViolationException) {
        log.warn("[constraintViolationExceptionHandler]", (Throwable)constraintViolationException);
        ConstraintViolation constraintViolation = (ConstraintViolation)constraintViolationException.getConstraintViolations().iterator().next();
        return CommonResult.error((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)MessageUtils.message((String)"system.constraint.violation.exception", (Object[])new Object[]{constraintViolation.getMessage()}));
    }

    @ExceptionHandler(value={ValidationException.class})
    public CommonResult<?> validationException(ValidationException validationException) {
        log.warn("[constraintViolationExceptionHandler]", (Throwable)validationException);
        return CommonResult.error((Integer)GlobalErrorCodeConstants.BAD_REQUEST.getCode(), (String)MessageUtils.message((String)"system.validation.exception", (Object[])new Object[0]));
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    public CommonResult<?> noHandlerFoundExceptionHandler(NoHandlerFoundException noHandlerFoundException) {
        log.warn("[noHandlerFoundExceptionHandler]", (Throwable)noHandlerFoundException);
        return CommonResult.error((Integer)GlobalErrorCodeConstants.NOT_FOUND.getCode(), (String)MessageUtils.message((String)"system.no.handler.found", (Object[])new Object[]{noHandlerFoundException.getRequestURL()}));
    }

    @ExceptionHandler(value={NoResourceFoundException.class})
    private CommonResult<?> noResourceFoundExceptionHandler(HttpServletRequest httpServletRequest, NoResourceFoundException noResourceFoundException) {
        log.warn("[noResourceFoundExceptionHandler]", (Throwable)noResourceFoundException);
        return CommonResult.error((Integer)GlobalErrorCodeConstants.NOT_FOUND.getCode(), (String)MessageUtils.message((String)"system.no.resource.found", (Object[])new Object[]{noResourceFoundException.getResourcePath()}));
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public CommonResult<?> httpRequestMethodNotSupportedExceptionHandler(HttpRequestMethodNotSupportedException httpRequestMethodNotSupportedException) {
        log.warn("[httpRequestMethodNotSupportedExceptionHandler]", (Throwable)httpRequestMethodNotSupportedException);
        return CommonResult.error((Integer)GlobalErrorCodeConstants.METHOD_NOT_ALLOWED.getCode(), (String)MessageUtils.message((String)"system.http.request.method.not.supported", (Object[])new Object[]{httpRequestMethodNotSupportedException.getMessage()}));
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public CommonResult<?> accessDeniedExceptionHandler(HttpServletRequest httpServletRequest, AccessDeniedException accessDeniedException) {
        log.warn("[accessDeniedExceptionHandler][userId({}) \u65e0\u6cd5\u8bbf\u95ee url({})]", new Object[]{WebFrameworkUtils.getLoginUserId(httpServletRequest), httpServletRequest.getRequestURL(), accessDeniedException});
        return CommonResult.error((ErrorCode)GlobalErrorCodeConstants.FORBIDDEN);
    }

    @ExceptionHandler(value={ServiceException.class})
    public CommonResult<?> serviceExceptionHandler(ServiceException serviceException) {
        if (!IGNORE_ERROR_MESSAGES.contains(serviceException.getMessage())) {
            try {
                StackTraceElement[] stackTraceElementArray;
                for (StackTraceElement stackTraceElement : stackTraceElementArray = serviceException.getStackTrace()) {
                    if (!ObjUtil.notEqual((Object)stackTraceElement.getClassName(), (Object)ServiceExceptionUtil.class.getName())) continue;
                    log.warn("[serviceExceptionHandler]\n\t{}", (Object)stackTraceElement);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return CommonResult.error((Integer)serviceException.getCode(), (String)serviceException.getMessage());
    }

    @ExceptionHandler(value={ServerException.class})
    public CommonResult<?> serverExceptionHandler(ServerException serverException) {
        log.warn("[serverExceptionHandler]", (Throwable)serverException);
        return CommonResult.error((Integer)serverException.getCode(), (String)serverException.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public CommonResult<?> defaultExceptionHandler(HttpServletRequest httpServletRequest, Throwable throwable) {
        CommonResult<?> commonResult = this.handleTableNotExists(throwable);
        if (commonResult != null) {
            return commonResult;
        }
        log.error("[defaultExceptionHandler]", throwable);
        this.createExceptionLog(httpServletRequest, throwable);
        return CommonResult.error((Integer)GlobalErrorCodeConstants.INTERNAL_SERVER_ERROR.getCode(), (String)GlobalErrorCodeConstants.INTERNAL_SERVER_ERROR.getMsg());
    }

    private void createExceptionLog(HttpServletRequest httpServletRequest, Throwable throwable) {
        ApiErrorLogCreateReqDTO apiErrorLogCreateReqDTO = new ApiErrorLogCreateReqDTO();
        try {
            this.buildExceptionLog(apiErrorLogCreateReqDTO, httpServletRequest, throwable);
            this.apiErrorLogApi.createApiErrorLogAsync(apiErrorLogCreateReqDTO);
        }
        catch (Throwable throwable2) {
            log.error("[createExceptionLog][url({}) log({}) \u53d1\u751f\u5f02\u5e38]", new Object[]{httpServletRequest.getRequestURI(), JsonUtils.toJsonString((Object)apiErrorLogCreateReqDTO), throwable2});
        }
    }

    private void buildExceptionLog(ApiErrorLogCreateReqDTO apiErrorLogCreateReqDTO, HttpServletRequest httpServletRequest, Throwable throwable) {
        apiErrorLogCreateReqDTO.setUserId(WebFrameworkUtils.getLoginUserId(httpServletRequest));
        apiErrorLogCreateReqDTO.setUserType(WebFrameworkUtils.getLoginUserType(httpServletRequest));
        apiErrorLogCreateReqDTO.setExceptionName(throwable.getClass().getName());
        apiErrorLogCreateReqDTO.setExceptionMessage(ExceptionUtil.getMessage((Throwable)throwable));
        apiErrorLogCreateReqDTO.setExceptionRootCauseMessage(ExceptionUtil.getRootCauseMessage((Throwable)throwable));
        apiErrorLogCreateReqDTO.setExceptionStackTrace(ExceptionUtil.stacktraceToString((Throwable)throwable));
        Object[] objectArray = throwable.getStackTrace();
        Assert.notEmpty((Object[])objectArray, (String)"\u5f02\u5e38 stackTraceElements \u4e0d\u80fd\u4e3a\u7a7a");
        Object object = objectArray[0];
        apiErrorLogCreateReqDTO.setExceptionClassName(((StackTraceElement)object).getClassName());
        apiErrorLogCreateReqDTO.setExceptionFileName(((StackTraceElement)object).getFileName());
        apiErrorLogCreateReqDTO.setExceptionMethodName(((StackTraceElement)object).getMethodName());
        apiErrorLogCreateReqDTO.setExceptionLineNumber(Integer.valueOf(((StackTraceElement)object).getLineNumber()));
        apiErrorLogCreateReqDTO.setTraceId(TracerUtils.getTraceId());
        apiErrorLogCreateReqDTO.setApplicationName(this.applicationName);
        apiErrorLogCreateReqDTO.setRequestUrl(httpServletRequest.getRequestURI());
        Map map = MapUtil.builder().put((Object)"query", (Object)JakartaServletUtil.getParamMap((ServletRequest)httpServletRequest)).put((Object)"body", (Object)JakartaServletUtil.getBody((ServletRequest)httpServletRequest)).build();
        apiErrorLogCreateReqDTO.setRequestParams(JsonUtils.toJsonString((Object)map));
        apiErrorLogCreateReqDTO.setRequestMethod(httpServletRequest.getMethod());
        apiErrorLogCreateReqDTO.setUserAgent(ServletUtils.getUserAgent((HttpServletRequest)httpServletRequest));
        apiErrorLogCreateReqDTO.setUserIp(JakartaServletUtil.getClientIP((HttpServletRequest)httpServletRequest, (String[])new String[0]));
        apiErrorLogCreateReqDTO.setExceptionTime(LocalDateTime.now());
    }

    private CommonResult<?> handleTableNotExists(Throwable throwable) {
        String string = ExceptionUtil.getRootCauseMessage((Throwable)throwable);
        if (!string.contains("doesn't exist")) {
            return null;
        }
        return null;
    }

    @Generated
    public GlobalExceptionHandler(String string, ApiErrorLogApi apiErrorLogApi) {
        this.applicationName = string;
        this.apiErrorLogApi = apiErrorLogApi;
    }
}

