/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.web.core.util;

import cn.hutool.core.util.NumberUtil;
import com.lenovo.cloud.framework.common.enums.TerminalEnum;
import com.lenovo.cloud.framework.common.enums.UserTypeEnum;
import com.lenovo.cloud.framework.common.pojo.CommonResult;
import com.lenovo.cloud.framework.web.config.WebProperties;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class WebFrameworkUtils {
    private static final String REQUEST_ATTRIBUTE_LOGIN_USER_ID = "login_user_id";
    private static final String REQUEST_ATTRIBUTE_LOGIN_USER_TYPE = "login_user_type";
    private static final String REQUEST_ATTRIBUTE_COMMON_RESULT = "common_result";
    public static final String HEADER_TENANT_ID = "tenant-id";
    public static final String HEADER_TERMINAL = "terminal";
    private static WebProperties properties;

    public WebFrameworkUtils(WebProperties webProperties) {
        properties = webProperties;
    }

    public static Long getTenantId(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getHeader(HEADER_TENANT_ID);
        return NumberUtil.isNumber((CharSequence)string) ? Long.valueOf(string) : null;
    }

    public static void setLoginUserId(ServletRequest servletRequest, Long l) {
        servletRequest.setAttribute(REQUEST_ATTRIBUTE_LOGIN_USER_ID, (Object)l);
    }

    public static void setLoginUserType(ServletRequest servletRequest, Integer n) {
        servletRequest.setAttribute(REQUEST_ATTRIBUTE_LOGIN_USER_TYPE, (Object)n);
    }

    public static Long getLoginUserId(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return null;
        }
        return (Long)httpServletRequest.getAttribute(REQUEST_ATTRIBUTE_LOGIN_USER_ID);
    }

    public static Integer getLoginUserType(HttpServletRequest httpServletRequest) {
        if (httpServletRequest == null) {
            return null;
        }
        Integer n = (Integer)httpServletRequest.getAttribute(REQUEST_ATTRIBUTE_LOGIN_USER_TYPE);
        if (n != null) {
            return n;
        }
        if (httpServletRequest.getServletPath().startsWith(properties.getAdminApi().getPrefix())) {
            return UserTypeEnum.ADMIN.getValue();
        }
        if (httpServletRequest.getServletPath().startsWith(properties.getAppApi().getPrefix())) {
            return UserTypeEnum.MEMBER.getValue();
        }
        return null;
    }

    public static Integer getLoginUserType() {
        HttpServletRequest httpServletRequest = WebFrameworkUtils.getRequest();
        return WebFrameworkUtils.getLoginUserType(httpServletRequest);
    }

    public static Long getLoginUserId() {
        HttpServletRequest httpServletRequest = WebFrameworkUtils.getRequest();
        return WebFrameworkUtils.getLoginUserId(httpServletRequest);
    }

    public static Integer getTerminal() {
        HttpServletRequest httpServletRequest = WebFrameworkUtils.getRequest();
        if (httpServletRequest == null) {
            return TerminalEnum.UNKNOWN.getTerminal();
        }
        String string = httpServletRequest.getHeader(HEADER_TERMINAL);
        return NumberUtil.parseInt((String)string, (Integer)TerminalEnum.UNKNOWN.getTerminal());
    }

    public static void setCommonResult(ServletRequest servletRequest, CommonResult<?> commonResult) {
        servletRequest.setAttribute(REQUEST_ATTRIBUTE_COMMON_RESULT, commonResult);
    }

    public static CommonResult<?> getCommonResult(ServletRequest servletRequest) {
        return (CommonResult)servletRequest.getAttribute(REQUEST_ATTRIBUTE_COMMON_RESULT);
    }

    public static HttpServletRequest getRequest() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (!(requestAttributes instanceof ServletRequestAttributes)) {
            return null;
        }
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)requestAttributes;
        return servletRequestAttributes.getRequest();
    }

    public static boolean isRpcRequest(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getRequestURI().startsWith("/rpc-api");
    }

    public static boolean isRpcRequest(String string) {
        return string.endsWith("Api");
    }
}

