/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.xss.config;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.lenovo.cloud.framework.web.config.LenovoWebAutoConfiguration;
import com.lenovo.cloud.framework.xss.config.XssProperties;
import com.lenovo.cloud.framework.xss.core.clean.JsoupXssCleaner;
import com.lenovo.cloud.framework.xss.core.clean.XssCleaner;
import com.lenovo.cloud.framework.xss.core.filter.XssFilter;
import com.lenovo.cloud.framework.xss.core.json.XssStringJsonDeserializer;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@AutoConfiguration
@EnableConfigurationProperties(value={XssProperties.class})
@ConditionalOnProperty(prefix="lenovo.xss", name={"enable"}, havingValue="true", matchIfMissing=true)
public class LenovoXssAutoConfiguration
implements WebMvcConfigurer {
    @Bean
    @ConditionalOnMissingBean(value={XssCleaner.class})
    public XssCleaner xssCleaner() {
        return new JsoupXssCleaner();
    }

    @Bean
    @ConditionalOnMissingBean(name={"xssJacksonCustomizer"})
    @ConditionalOnBean(value={ObjectMapper.class})
    @ConditionalOnProperty(value={"lenovo.xss.enable"}, havingValue="true")
    public Jackson2ObjectMapperBuilderCustomizer xssJacksonCustomizer(XssProperties xssProperties, PathMatcher pathMatcher, XssCleaner xssCleaner) {
        return jackson2ObjectMapperBuilder -> jackson2ObjectMapperBuilder.deserializerByType(String.class, (JsonDeserializer)new XssStringJsonDeserializer(xssProperties, pathMatcher, xssCleaner));
    }

    @Bean
    @ConditionalOnBean(value={XssCleaner.class})
    public FilterRegistrationBean<XssFilter> xssFilter(XssProperties xssProperties, PathMatcher pathMatcher, XssCleaner xssCleaner) {
        return LenovoWebAutoConfiguration.createFilterBean(new XssFilter(xssProperties, pathMatcher, xssCleaner), -102);
    }
}

