/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.xss.core.filter;

import com.lenovo.cloud.framework.xss.config.XssProperties;
import com.lenovo.cloud.framework.xss.core.clean.XssCleaner;
import com.lenovo.cloud.framework.xss.core.filter.XssRequestWrapper;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.springframework.util.PathMatcher;
import org.springframework.web.filter.OncePerRequestFilter;

public class XssFilter
extends OncePerRequestFilter {
    private final XssProperties properties;
    private final PathMatcher pathMatcher;
    private final XssCleaner xssCleaner;

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws IOException, ServletException {
        filterChain.doFilter((ServletRequest)new XssRequestWrapper(httpServletRequest, this.xssCleaner), (ServletResponse)httpServletResponse);
    }

    protected boolean shouldNotFilter(HttpServletRequest httpServletRequest) {
        if (!this.properties.isEnable()) {
            return true;
        }
        String string = httpServletRequest.getRequestURI();
        return this.properties.getExcludeUrls().stream().anyMatch(string2 -> this.pathMatcher.match(string2, string));
    }

    @Generated
    public XssFilter(XssProperties xssProperties, PathMatcher pathMatcher, XssCleaner xssCleaner) {
        this.properties = xssProperties;
        this.pathMatcher = pathMatcher;
        this.xssCleaner = xssCleaner;
    }
}

