/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.xss.core.filter;

import com.lenovo.cloud.framework.xss.core.clean.XssCleaner;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.LinkedHashMap;
import java.util.Map;

public class XssRequestWrapper
extends HttpServletRequestWrapper {
    private final XssCleaner xssCleaner;

    public XssRequestWrapper(HttpServletRequest httpServletRequest, XssCleaner xssCleaner) {
        super(httpServletRequest);
        this.xssCleaner = xssCleaner;
    }

    public Map<String, String[]> getParameterMap() {
        LinkedHashMap<String, String[]> linkedHashMap = new LinkedHashMap<String, String[]>();
        Map map = super.getParameterMap();
        for (Map.Entry entry : map.entrySet()) {
            String[] stringArray = (String[])entry.getValue();
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.xssCleaner.clean(stringArray[i]);
            }
            linkedHashMap.put((String)entry.getKey(), stringArray);
        }
        return linkedHashMap;
    }

    public String[] getParameterValues(String string) {
        String[] stringArray = super.getParameterValues(string);
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = this.xssCleaner.clean(stringArray[i]);
        }
        return stringArray2;
    }

    public String getParameter(String string) {
        String string2 = super.getParameter(string);
        if (string2 == null) {
            return null;
        }
        return this.xssCleaner.clean(string2);
    }

    public Object getAttribute(String string) {
        Object object = super.getAttribute(string);
        if (object instanceof String) {
            return this.xssCleaner.clean((String)object);
        }
        return object;
    }

    public String getHeader(String string) {
        String string2 = super.getHeader(string);
        if (string2 == null) {
            return null;
        }
        return this.xssCleaner.clean(string2);
    }

    public String getQueryString() {
        String string = super.getQueryString();
        if (string == null) {
            return null;
        }
        return this.xssCleaner.clean(string);
    }
}

