/*
 * Decompiled with CFR 0.152.
 */
package com.lenovo.cloud.framework.xss.core.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.StringDeserializer;
import com.lenovo.cloud.framework.common.util.servlet.ServletUtils;
import com.lenovo.cloud.framework.xss.config.XssProperties;
import com.lenovo.cloud.framework.xss.core.clean.XssCleaner;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.PathMatcher;

public class XssStringJsonDeserializer
extends StringDeserializer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XssStringJsonDeserializer.class);
    private final XssProperties properties;
    private final PathMatcher pathMatcher;
    private final XssCleaner xssCleaner;

    public String deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        String string;
        HttpServletRequest httpServletRequest = ServletUtils.getRequest();
        if (httpServletRequest != null) {
            string = ServletUtils.getRequest().getRequestURI();
            if (this.properties.getExcludeUrls().stream().anyMatch(string2 -> this.pathMatcher.match(string2, string))) {
                return jsonParser.getText();
            }
        }
        if (jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return this.xssCleaner.clean(jsonParser.getText());
        }
        string = jsonParser.currentToken();
        if (string == JsonToken.START_ARRAY) {
            return (String)this._deserializeFromArray(jsonParser, deserializationContext);
        }
        if (string == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object object = jsonParser.getEmbeddedObject();
            if (object == null) {
                return null;
            }
            if (object instanceof byte[]) {
                return deserializationContext.getBase64Variant().encode((byte[])object, false);
            }
            return object.toString();
        }
        if (string == JsonToken.START_OBJECT) {
            return deserializationContext.extractScalarFromObject(jsonParser, (JsonDeserializer)this, this._valueClass);
        }
        if (string.isScalarValue()) {
            String string3 = jsonParser.getValueAsString();
            return this.xssCleaner.clean(string3);
        }
        return (String)deserializationContext.handleUnexpectedToken(this._valueClass, jsonParser);
    }

    @Generated
    public XssStringJsonDeserializer(XssProperties xssProperties, PathMatcher pathMatcher, XssCleaner xssCleaner) {
        this.properties = xssProperties;
        this.pathMatcher = pathMatcher;
        this.xssCleaner = xssCleaner;
    }
}

